/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import com.avanza.gs.test.AsyncPuRunner;
import com.avanza.gs.test.ContextProperties;
import com.avanza.gs.test.JVMGlobalLus;
import com.avanza.gs.test.PartitionedPu;
import com.avanza.gs.test.RunningPu;
import com.avanza.gs.test.RunningPuImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ApplicationContext;

public final class PartitionedPuConfigurer {
    String puXmlPath;
    int numberOfPrimaries = 1;
    int numberOfBackups = 0;
    boolean startAsync = false;
    Properties contextProperties = new Properties();
    Map<String, Properties> beanProperies = new HashMap<String, Properties>();
    String lookupGroupName = JVMGlobalLus.getLookupGroupName();
    String spaceName = "test-space";
    public boolean autostart = true;
    ApplicationContext parentContext;
    boolean useAuthentication;

    public PartitionedPuConfigurer(String puXmlPath) {
        this.puXmlPath = puXmlPath;
    }

    public PartitionedPuConfigurer parentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
        return this;
    }

    public PartitionedPuConfigurer numberOfPrimaries(int numberOfPrimaries) {
        this.numberOfPrimaries = numberOfPrimaries;
        return this;
    }

    public PartitionedPuConfigurer numberOfBackups(int numberOfBackups) {
        this.numberOfBackups = numberOfBackups;
        return this;
    }

    public PartitionedPuConfigurer beanProperties(String beanName, Properties beanProperties) {
        this.beanProperies.put(beanName, beanProperties);
        return this;
    }

    public PartitionedPuConfigurer startAsync(boolean startAsync) {
        this.startAsync = startAsync;
        return this;
    }

    public PartitionedPuConfigurer lookupGroup(String group) {
        this.lookupGroupName = group;
        return this;
    }

    @Deprecated
    public PartitionedPuConfigurer groupName(String group) {
        this.lookupGroupName = group;
        return this;
    }

    public RunningPu configure() {
        if (this.startAsync) {
            return new RunningPuImpl(new AsyncPuRunner(new PartitionedPu(this)));
        }
        return new RunningPuImpl(new PartitionedPu(this));
    }

    public PartitionedPuConfigurer contextProperties(Properties properties) {
        this.contextProperties = properties;
        return this;
    }

    public PartitionedPuConfigurer contextProperties(ContextProperties properties) {
        this.contextProperties = properties.getProperties();
        return this;
    }

    public PartitionedPuConfigurer contextProperty(String name, String value) {
        this.contextProperties.setProperty(name, value);
        return this;
    }

    public PartitionedPuConfigurer autostart(boolean autostart) {
        this.autostart = autostart;
        return this;
    }

    public PartitionedPuConfigurer spaceName(String spaceName) {
        this.spaceName = spaceName;
        return this;
    }

    public PartitionedPuConfigurer withAuthentication() {
        this.useAuthentication = true;
        return this;
    }
}

