/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import com.avanza.gs.test.PuRunner;
import com.avanza.gs.test.RunningPu;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openspaces.core.GigaSpace;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class RunningPuImpl
implements RunningPu {
    private final PuRunner runner;
    private volatile State state;

    public RunningPuImpl(PuRunner runner) {
        this.runner = runner;
        this.state = State.NEW;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    if (RunningPuImpl.this.runner.autostart()) {
                        RunningPuImpl.this.start();
                    }
                    base.evaluate();
                }
                finally {
                    try {
                        RunningPuImpl.this.stop();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    @Override
    public synchronized void start() throws Exception {
        System.setProperty("com.gs.jini_lus.groups", this.runner.getLookupGroupName());
        this.state = this.state.start(this.runner);
    }

    @Override
    public synchronized void stop() throws Exception {
        this.state = this.state.stop(this.runner);
    }

    @Override
    public String getLookupGroupName() {
        return this.runner.getLookupGroupName();
    }

    @Override
    public GigaSpace getClusteredGigaSpace() {
        return this.runner.getClusteredGigaSpace();
    }

    @Override
    public BeanFactory getPrimaryInstanceApplicationContext(int partition) {
        return this.runner.getPrimaryInstanceApplicationContext(partition);
    }

    @Override
    public Collection<ListableBeanFactory> getApplicationContexts() {
        return IntStream.range(0, this.runner.getNumInstances()).mapToObj(partition -> this.runner.getPrimaryInstanceApplicationContext(partition)).collect(Collectors.toList());
    }

    static enum State {
        NEW{

            @Override
            State start(PuRunner runner) throws Exception {
                runner.run();
                return RUNNING;
            }

            @Override
            State stop(PuRunner runner) {
                return CLOSED;
            }
        }
        ,
        RUNNING{

            @Override
            State start(PuRunner runner) {
                throw new IllegalStateException("Pu already running!");
            }

            @Override
            State stop(PuRunner runner) throws Exception {
                runner.shutdown();
                return CLOSED;
            }
        }
        ,
        CLOSED{

            @Override
            State start(PuRunner runner) throws Exception {
                runner.run();
                return RUNNING;
            }

            @Override
            State stop(PuRunner runner) {
                return CLOSED;
            }
        };


        abstract State start(PuRunner var1) throws Exception;

        abstract State stop(PuRunner var1) throws Exception;
    }
}

