/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.gs.test;

import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.SecurityManager;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import java.io.Serializable;
import java.util.Properties;
import java.util.stream.Stream;

public class SecurityManagerForTests
implements SecurityManager,
Serializable {
    public static final String TEST_USER = "testuser";
    public static final String TEST_PASS = "testpass";
    private static final Authority[] TEST_AUTHORITIES = (Authority[])Stream.of(SpaceAuthority.SpacePrivilege.values()).map(SpaceAuthority::new).toArray(Authority[]::new);

    public void init(Properties properties) throws SecurityException {
    }

    public void close() {
    }

    public DirectoryManager createDirectoryManager(UserDetails userDetails) throws AuthenticationException, AccessDeniedException {
        throw new UnsupportedOperationException("DirectoryManager is not supported by SecurityManagerForTests");
    }

    public Authentication authenticate(UserDetails u) throws AuthenticationException {
        if (!TEST_USER.equals(u.getUsername())) {
            throw new AuthenticationException("Incorrect auth username for test login. Expected [testuser] but received [" + u.getUsername() + "]");
        }
        if (!TEST_PASS.equals(u.getPassword())) {
            throw new AuthenticationException("Incorrect auth password for test login. Expected [testpass] but received [" + u.getPassword() + "]");
        }
        return new Authentication((UserDetails)new User(TEST_USER, TEST_PASS, TEST_AUTHORITIES));
    }
}

