/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.hystrix.multiconfig;

import com.avanza.hystrix.multiconfig.Dispatcher;
import com.avanza.hystrix.multiconfig.MultiConfigId;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class MultiConcurrencyStrategyDispatcher
extends HystrixConcurrencyStrategy
implements Dispatcher<HystrixConcurrencyStrategy> {
    private final Map<MultiConfigId, HystrixConcurrencyStrategy> strategies = new ConcurrentHashMap<MultiConfigId, HystrixConcurrencyStrategy>();
    private final AtomicReference<HystrixConcurrencyStrategy> underlying = new AtomicReference();

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixProperty<Integer> corePoolSize, HystrixProperty<Integer> maximumPoolSize, HystrixProperty<Integer> keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        if (MultiConfigId.hasMultiSourceId(threadPoolKey)) {
            return this.strategies.get(MultiConfigId.readFrom(threadPoolKey)).getThreadPool(MultiConfigId.decode(threadPoolKey), corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }
        return this.underlying().map(strategy -> strategy.getThreadPool(threadPoolKey, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue)).orElseGet(() -> super.getThreadPool(threadPoolKey, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue));
    }

    public <T> HystrixRequestVariable<T> getRequestVariable(HystrixRequestVariableLifecycle<T> rv) {
        return this.underlying().map(strategy -> strategy.getRequestVariable(rv)).orElseGet(() -> super.getRequestVariable(rv));
    }

    public BlockingQueue<Runnable> getBlockingQueue(int maxQueueSize) {
        return this.underlying().map(strategy -> strategy.getBlockingQueue(maxQueueSize)).orElseGet(() -> super.getBlockingQueue(maxQueueSize));
    }

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return this.underlying().map(strategy -> strategy.wrapCallable(callable)).orElseGet(() -> super.wrapCallable(callable));
    }

    public void register(String id, HystrixConcurrencyStrategy strategy) {
        this.strategies.put(MultiConfigId.create(id), strategy);
    }

    public boolean containsMapping(String id) {
        return this.strategies.containsKey(MultiConfigId.create(id));
    }

    private Optional<HystrixConcurrencyStrategy> underlying() {
        return Optional.ofNullable(this.underlying.get());
    }

    @Override
    public void setUnderlying(HystrixConcurrencyStrategy underlying) {
        this.underlying.set(underlying);
    }

    @Override
    public HystrixConcurrencyStrategy instance() {
        return this;
    }
}

