/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.hystrix.multiconfig;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiConfigId {
    private static Pattern pattern = Pattern.compile("\\[([a-zA-Z0-9-_]+)\\](.+)");
    private String propertySourceId;

    private MultiConfigId(String propertySourceId) {
        this.propertySourceId = Objects.requireNonNull(propertySourceId);
    }

    public static MultiConfigId create(String id) {
        return new MultiConfigId(id);
    }

    public static MultiConfigId readFrom(HystrixCommandKey commandKey) {
        return MultiConfigId.consumeMatch(commandKey.name(), matcher -> MultiConfigId.create(matcher.group(1)));
    }

    public static MultiConfigId readFrom(HystrixCollapserKey collapserKey) {
        return MultiConfigId.consumeMatch(collapserKey.name(), matcher -> MultiConfigId.create(matcher.group(1)));
    }

    public static MultiConfigId readFrom(HystrixThreadPoolKey threadPoolKey) {
        return MultiConfigId.consumeMatch(threadPoolKey.name(), matcher -> MultiConfigId.create(matcher.group(1)));
    }

    public static boolean hasMultiSourceId(HystrixCommandKey commandKey) {
        return pattern.matcher(commandKey.name()).find();
    }

    public static boolean hasMultiSourceId(HystrixCollapserKey collapserKey) {
        return pattern.matcher(collapserKey.name()).find();
    }

    public static boolean hasMultiSourceId(HystrixThreadPoolKey threadPoolKey) {
        return pattern.matcher(threadPoolKey.name()).find();
    }

    public static HystrixCommandKey decode(HystrixCommandKey commandKey) {
        return MultiConfigId.consumeMatch(commandKey.name(), matcher -> HystrixCommandKey.Factory.asKey((String)matcher.group(2)));
    }

    public static HystrixCollapserKey decode(HystrixCollapserKey collapserKey) {
        return MultiConfigId.consumeMatch(collapserKey.name(), matcher -> HystrixCollapserKey.Factory.asKey((String)matcher.group(2)));
    }

    public static HystrixThreadPoolKey decode(HystrixThreadPoolKey threadPoolKey) {
        return MultiConfigId.consumeMatch(threadPoolKey.name(), matcher -> HystrixThreadPoolKey.Factory.asKey((String)matcher.group(2)));
    }

    private static <T> T consumeMatch(String name, Function<Matcher, T> mapping) {
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            return mapping.apply(matcher);
        }
        throw new IllegalArgumentException("Could not read id from name=" + name);
    }

    public HystrixCommandKey encode(HystrixCommandKey hystrixCommandKey) {
        return this.createCommandKey(hystrixCommandKey.name());
    }

    public HystrixCommandGroupKey encode(HystrixCommandGroupKey hystrixCommandGroupKey) {
        return this.createCommandGroupKey(hystrixCommandGroupKey.name());
    }

    public HystrixCollapserKey encode(HystrixCollapserKey hystrixCollapserKey) {
        return this.createCollapserKey(hystrixCollapserKey.name());
    }

    public HystrixThreadPoolKey encode(HystrixThreadPoolKey hystrixThreadPoolKey) {
        return this.createThreadPoolKey(hystrixThreadPoolKey.name());
    }

    public HystrixCommandKey createCommandKey(String commandKeyName) {
        return HystrixCommandKey.Factory.asKey((String)(this.getPrefix() + commandKeyName));
    }

    public HystrixCommandGroupKey createCommandGroupKey(String commandKeyName) {
        return HystrixCommandGroupKey.Factory.asKey((String)(this.getPrefix() + commandKeyName));
    }

    public HystrixCollapserKey createCollapserKey(String commandGroupName) {
        return HystrixCollapserKey.Factory.asKey((String)(this.getPrefix() + commandGroupName));
    }

    public HystrixThreadPoolKey createThreadPoolKey(String threadPoolKey) {
        return HystrixThreadPoolKey.Factory.asKey((String)(this.getPrefix() + threadPoolKey));
    }

    public String getPrefix() {
        return "[" + this.propertySourceId + "]";
    }

    public int hashCode() {
        return Objects.hash(this.propertySourceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiConfigId other = (MultiConfigId)obj;
        return this.propertySourceId.equals(other.propertySourceId);
    }

    public String toString() {
        return this.propertySourceId;
    }
}

