/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.hystrix.multiconfig;

import com.avanza.hystrix.multiconfig.Dispatcher;
import com.avanza.hystrix.multiconfig.MultiConcurrencyStrategyDispatcher;
import com.avanza.hystrix.multiconfig.MultiEventNotifierDispatcher;
import com.avanza.hystrix.multiconfig.MultiPropertiesStrategyDispatcher;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiConfigs {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiConfigs.class);
    private static MultiPropertiesStrategyDispatcher multiPropertiesStrategyDispatcher = new MultiPropertiesStrategyDispatcher();
    private static MultiConcurrencyStrategyDispatcher multiConcurrencyStrategyDispatcher = new MultiConcurrencyStrategyDispatcher();
    private static MultiEventNotifierDispatcher multiEventNotifierDispatcher = new MultiEventNotifierDispatcher();

    public static void register(String id, HystrixPropertiesStrategy strategy) {
        multiPropertiesStrategyDispatcher.register(id, strategy);
        MultiConfigs.verifyRegistered();
    }

    public static void register(String id, HystrixConcurrencyStrategy strategy) {
        multiConcurrencyStrategyDispatcher.register(id, strategy);
        MultiConfigs.verifyRegistered();
    }

    public static void register(String id, HystrixEventNotifier strategy) {
        multiEventNotifierDispatcher.register(id, strategy);
        MultiConfigs.verifyRegistered();
    }

    public static boolean containsAllMappings(String id) {
        return multiPropertiesStrategyDispatcher.containsMapping(id) && multiConcurrencyStrategyDispatcher.containsMapping(id) && multiEventNotifierDispatcher.containsMapping(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyRegistered() {
        MultiPropertiesStrategyDispatcher multiPropertiesStrategyDispatcher = MultiConfigs.multiPropertiesStrategyDispatcher;
        synchronized (multiPropertiesStrategyDispatcher) {
            if (!HystrixPlugins.getInstance().getPropertiesStrategy().getClass().equals(MultiPropertiesStrategyDispatcher.class)) {
                LOGGER.warn(MultiPropertiesStrategyDispatcher.class.getName() + " not yet registered with Hystrix, registering...");
                MultiConfigs.registerWithHystrix();
            }
        }
    }

    private static void registerWithHystrix() {
        HystrixEventNotifier eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        HystrixMetricsPublisher metricsPublisher = HystrixPlugins.getInstance().getMetricsPublisher();
        HystrixPropertiesStrategy propertiesStrategy = HystrixPlugins.getInstance().getPropertiesStrategy();
        HystrixCommandExecutionHook commandExecutionHook = HystrixPlugins.getInstance().getCommandExecutionHook();
        HystrixPlugins.reset();
        MultiConfigs.reRegister(eventNotifier, multiEventNotifierDispatcher, notifier -> HystrixPlugins.getInstance().registerEventNotifier(notifier));
        MultiConfigs.reRegister(concurrencyStrategy, multiConcurrencyStrategyDispatcher, strategy -> HystrixPlugins.getInstance().registerConcurrencyStrategy(strategy));
        HystrixPlugins.getInstance().registerMetricsPublisher(metricsPublisher);
        MultiConfigs.reRegister(propertiesStrategy, multiPropertiesStrategyDispatcher, strategy -> HystrixPlugins.getInstance().registerPropertiesStrategy(strategy));
        HystrixPlugins.getInstance().registerCommandExecutionHook(commandExecutionHook);
        LOGGER.info(MultiPropertiesStrategyDispatcher.class.getName() + " registered with Hystrix!");
    }

    private static <T> void reRegister(T previous, Dispatcher<T> dispatcher, Consumer<T> registrar) {
        if (!(previous instanceof Dispatcher)) {
            dispatcher.setUnderlying(previous);
        }
        registrar.accept(dispatcher.instance());
    }

    static {
        MultiConfigs.registerWithHystrix();
    }
}

