/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.hystrix.multiconfig;

import com.avanza.hystrix.multiconfig.Dispatcher;
import com.avanza.hystrix.multiconfig.MultiConfigId;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class MultiEventNotifierDispatcher
extends HystrixEventNotifier
implements Dispatcher<HystrixEventNotifier> {
    private Map<MultiConfigId, HystrixEventNotifier> strategies = new ConcurrentHashMap<MultiConfigId, HystrixEventNotifier>();
    private final AtomicReference<HystrixEventNotifier> underlying = new AtomicReference();

    public void markCommandExecution(HystrixCommandKey key, HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy, int duration, List<HystrixEventType> eventsDuringExecution) {
        if (MultiConfigId.hasMultiSourceId(key)) {
            this.strategies.get(MultiConfigId.readFrom(key)).markCommandExecution(MultiConfigId.decode(key), isolationStrategy, duration, eventsDuringExecution);
        } else {
            this.underlying().map(notifier -> {
                notifier.markCommandExecution(key, isolationStrategy, duration, eventsDuringExecution);
                return null;
            }).orElseGet(() -> {
                super.markCommandExecution(key, isolationStrategy, duration, eventsDuringExecution);
                return null;
            });
        }
    }

    public void markEvent(HystrixEventType eventType, HystrixCommandKey key) {
        if (MultiConfigId.hasMultiSourceId(key)) {
            this.strategies.get(MultiConfigId.readFrom(key)).markEvent(eventType, MultiConfigId.decode(key));
        } else {
            this.underlying().map(notifier -> {
                notifier.markEvent(eventType, key);
                return null;
            }).orElseGet(() -> {
                super.markEvent(eventType, key);
                return null;
            });
        }
    }

    public void register(String id, HystrixEventNotifier strategy) {
        this.strategies.put(MultiConfigId.create(id), strategy);
    }

    public boolean containsMapping(String id) {
        return this.strategies.containsKey(MultiConfigId.create(id));
    }

    private Optional<HystrixEventNotifier> underlying() {
        return Optional.ofNullable(this.underlying.get());
    }

    @Override
    public void setUnderlying(HystrixEventNotifier underlying) {
        this.underlying.set(underlying);
    }

    @Override
    public HystrixEventNotifier instance() {
        return this;
    }
}

