/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.hystrix.multiconfig;

import com.avanza.hystrix.multiconfig.Dispatcher;
import com.avanza.hystrix.multiconfig.MultiConfigId;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.HystrixTimerThreadPoolProperties;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class MultiPropertiesStrategyDispatcher
extends HystrixPropertiesStrategy
implements Dispatcher<HystrixPropertiesStrategy> {
    private final Map<MultiConfigId, HystrixPropertiesStrategy> strategies = new ConcurrentHashMap<MultiConfigId, HystrixPropertiesStrategy>();
    private final AtomicReference<HystrixPropertiesStrategy> underlying = new AtomicReference();

    public HystrixCommandProperties getCommandProperties(HystrixCommandKey qualifiedCommandKey, HystrixCommandProperties.Setter builder) {
        if (MultiConfigId.hasMultiSourceId(qualifiedCommandKey)) {
            return this.strategies.get(MultiConfigId.readFrom(qualifiedCommandKey)).getCommandProperties(MultiConfigId.decode(qualifiedCommandKey), builder);
        }
        return this.underlying().map(strategy -> strategy.getCommandProperties(qualifiedCommandKey, builder)).orElseGet(() -> super.getCommandProperties(qualifiedCommandKey, builder));
    }

    public HystrixThreadPoolProperties getThreadPoolProperties(HystrixThreadPoolKey qualifiedThreadPoolKey, HystrixThreadPoolProperties.Setter builder) {
        if (MultiConfigId.hasMultiSourceId(qualifiedThreadPoolKey)) {
            return this.strategies.get(MultiConfigId.readFrom(qualifiedThreadPoolKey)).getThreadPoolProperties(MultiConfigId.decode(qualifiedThreadPoolKey), builder);
        }
        return this.underlying().map(strategy -> strategy.getThreadPoolProperties(qualifiedThreadPoolKey, builder)).orElseGet(() -> super.getThreadPoolProperties(qualifiedThreadPoolKey, builder));
    }

    public HystrixCollapserProperties getCollapserProperties(HystrixCollapserKey qualifiedCollapserKey, HystrixCollapserProperties.Setter builder) {
        if (MultiConfigId.hasMultiSourceId(qualifiedCollapserKey)) {
            return this.strategies.get(MultiConfigId.readFrom(qualifiedCollapserKey)).getCollapserProperties(MultiConfigId.decode(qualifiedCollapserKey), builder);
        }
        return this.underlying().map(strategy -> strategy.getCollapserProperties(qualifiedCollapserKey, builder)).orElseGet(() -> super.getCollapserProperties(qualifiedCollapserKey, builder));
    }

    public String getCommandPropertiesCacheKey(HystrixCommandKey commandKey, HystrixCommandProperties.Setter builder) {
        return this.underlying().map(strategy -> strategy.getCommandPropertiesCacheKey(commandKey, builder)).orElseGet(() -> super.getCommandPropertiesCacheKey(commandKey, builder));
    }

    public String getThreadPoolPropertiesCacheKey(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter builder) {
        return this.underlying().map(strategy -> strategy.getThreadPoolPropertiesCacheKey(threadPoolKey, builder)).orElseGet(() -> super.getThreadPoolPropertiesCacheKey(threadPoolKey, builder));
    }

    public String getCollapserPropertiesCacheKey(HystrixCollapserKey collapserKey, HystrixCollapserProperties.Setter builder) {
        return this.underlying().map(strategy -> strategy.getCollapserPropertiesCacheKey(collapserKey, builder)).orElseGet(() -> super.getCollapserPropertiesCacheKey(collapserKey, builder));
    }

    public HystrixTimerThreadPoolProperties getTimerThreadPoolProperties() {
        return this.underlying().map(HystrixPropertiesStrategy::getTimerThreadPoolProperties).orElseGet(() -> super.getTimerThreadPoolProperties());
    }

    public void register(String id, HystrixPropertiesStrategy strategy) {
        this.strategies.put(MultiConfigId.create(id), strategy);
    }

    public boolean containsMapping(String id) {
        return this.strategies.containsKey(MultiConfigId.create(id));
    }

    private Optional<HystrixPropertiesStrategy> underlying() {
        return Optional.ofNullable(this.underlying.get());
    }

    @Override
    public void setUnderlying(HystrixPropertiesStrategy underlying) {
        this.underlying.set(underlying);
    }

    @Override
    public HystrixPropertiesStrategy instance() {
        return this;
    }
}

