/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.DynamicProperty;
import com.avanza.astrix.config.DynamicPropertyListener;
import com.avanza.astrix.config.ListenerSupport;
import java.util.function.Supplier;

abstract class AbstractDynamicProperty<T>
implements DynamicProperty<T>,
Supplier<T> {
    private final ListenerSupport<DynamicPropertyListener<T>> listenerSupport = new ListenerSupport();
    private volatile T value;

    protected AbstractDynamicProperty(T initialValue) {
        this.value = initialValue;
    }

    protected AbstractDynamicProperty() {
        this.value = null;
    }

    @Override
    public T getCurrentValue() {
        return this.value;
    }

    @Override
    public T get() {
        return this.getCurrentValue();
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.listenerSupport.dispatchEvent(listener -> listener.propertyChanged(value));
    }

    public String toString() {
        return this.value == null ? null : String.valueOf(this.value);
    }

    @Override
    public void addListener(DynamicPropertyListener<T> listener) {
        this.listenerSupport.addListener(listener);
    }

    @Override
    public void removeListener(DynamicPropertyListener<T> listener) {
        this.listenerSupport.removeListener(listener);
    }
}

