/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.AbstractDynamicConfigSource;
import com.avanza.astrix.config.ConfigSource;
import com.avanza.astrix.config.DynamicBooleanProperty;
import com.avanza.astrix.config.DynamicConfigListener;
import com.avanza.astrix.config.DynamicConfigProperty;
import com.avanza.astrix.config.DynamicConfigSource;
import com.avanza.astrix.config.DynamicEnumProperty;
import com.avanza.astrix.config.DynamicIntProperty;
import com.avanza.astrix.config.DynamicListProperty;
import com.avanza.astrix.config.DynamicLongProperty;
import com.avanza.astrix.config.DynamicNullableBooleanProperty;
import com.avanza.astrix.config.DynamicNullableIntegerProperty;
import com.avanza.astrix.config.DynamicNullableLongProperty;
import com.avanza.astrix.config.DynamicOptionalProperty;
import com.avanza.astrix.config.DynamicProperty;
import com.avanza.astrix.config.DynamicPropertyChain;
import com.avanza.astrix.config.DynamicPropertyListener;
import com.avanza.astrix.config.DynamicSetProperty;
import com.avanza.astrix.config.DynamicStringProperty;
import com.avanza.astrix.config.ListenerSupport;
import com.avanza.astrix.config.PropertyParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class DynamicConfig {
    private final ConcurrentMap<CacheKey<? extends DynamicProperty<?>>, DynamicProperty<?>> configCache = new ConcurrentHashMap();
    private final List<DynamicConfigSource> configSources;
    private final ListenerSupport<DynamicConfigListener> dynamicConfigListenerSupport = new ListenerSupport();

    public DynamicConfig(ConfigSource configSource) {
        this(Collections.singletonList(configSource));
    }

    public DynamicConfig(List<? extends ConfigSource> configSources) {
        this.configSources = configSources.stream().map(configSource -> configSource instanceof DynamicConfigSource ? (DynamicConfigSource)configSource : new DynamicConfigSourceAdapter((ConfigSource)configSource)).collect(Collectors.toList());
    }

    public static DynamicConfig create(ConfigSource first, ConfigSource ... other) {
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        sources.add(first);
        sources.addAll(Arrays.asList(other));
        return new DynamicConfig(sources);
    }

    public static DynamicConfig create(List<? extends ConfigSource> sources) {
        return new DynamicConfig(sources);
    }

    public DynamicStringProperty getStringProperty(String name, String defaultValue) {
        return this.getProperty(name, DynamicStringProperty.class, defaultValue, PropertyParser.STRING_PARSER);
    }

    public DynamicOptionalProperty<String> getOptionalStringProperty(String name) {
        return new DynamicOptionalProperty<String>(this.getStringProperty(name, null));
    }

    public DynamicBooleanProperty getBooleanProperty(String name, boolean defaultValue) {
        return this.getProperty(name, DynamicBooleanProperty.class, defaultValue, PropertyParser.BOOLEAN_PARSER);
    }

    public DynamicOptionalProperty<Boolean> getOptionalBooleanProperty(String name) {
        return new DynamicOptionalProperty<Boolean>(this.getProperty(name, DynamicNullableBooleanProperty.class, null, PropertyParser.BOOLEAN_PARSER));
    }

    public DynamicLongProperty getLongProperty(String name, long defaultValue) {
        return this.getProperty(name, DynamicLongProperty.class, defaultValue, PropertyParser.LONG_PARSER);
    }

    public DynamicOptionalProperty<Long> getOptionalLongProperty(String name) {
        return new DynamicOptionalProperty<Long>(this.getProperty(name, DynamicNullableLongProperty.class, null, PropertyParser.LONG_PARSER));
    }

    public DynamicIntProperty getIntProperty(String name, int defaultValue) {
        return this.getProperty(name, DynamicIntProperty.class, defaultValue, PropertyParser.INT_PARSER);
    }

    public DynamicOptionalProperty<Integer> getOptionalIntegerProperty(String name) {
        return new DynamicOptionalProperty<Integer>(this.getProperty(name, DynamicNullableIntegerProperty.class, null, PropertyParser.INT_PARSER));
    }

    public <T extends Enum<T>> DynamicEnumProperty<T> getEnumProperty(String name, Class<T> enumClass, T defaultValue) {
        return this.getProperty(name, DynamicEnumProperty.class, defaultValue, PropertyParser.enumParser(enumClass));
    }

    public <T extends Enum<T>> DynamicOptionalProperty<T> getOptionalEnumProperty(String name, Class<T> enumClass) {
        return new DynamicOptionalProperty<Object>(this.getEnumProperty(name, enumClass, null));
    }

    public DynamicListProperty<String> getStringListProperty(String name, List<String> defaultValue) {
        return this.getProperty(name, DynamicListProperty.class, defaultValue, PropertyParser.STRING_LIST_PARSER);
    }

    public DynamicListProperty<Integer> getIntListProperty(String name, List<Integer> defaultValue) {
        return this.getProperty(name, DynamicListProperty.class, defaultValue, PropertyParser.INT_LIST_PARSER);
    }

    public DynamicListProperty<Long> getLongListProperty(String name, List<Long> defaultValue) {
        return this.getProperty(name, DynamicListProperty.class, defaultValue, PropertyParser.LONG_LIST_PARSER);
    }

    public DynamicListProperty<Boolean> getBooleanListProperty(String name, List<Boolean> defaultValue) {
        return this.getProperty(name, DynamicListProperty.class, defaultValue, PropertyParser.BOOLEAN_LIST_PARSER);
    }

    public <T extends Enum<T>> DynamicListProperty<T> getEnumListProperty(String name, Class<T> enumClass, List<T> defaultValue) {
        return this.getProperty(name, DynamicListProperty.class, defaultValue, PropertyParser.enumListParser(enumClass));
    }

    public <T extends Enum<T>> DynamicSetProperty<T> getEnumSetProperty(String name, Class<T> enumClass, Set<T> defaultValue) {
        return this.getProperty(name, DynamicSetProperty.class, defaultValue, PropertyParser.enumSetParser(enumClass));
    }

    private <T, P extends DynamicProperty<T>> P getProperty(String name, Class<P> propertyType, T defaultValue, PropertyParser<T> propertyParser) {
        return (P)this.getOrCreate(propertyType, name, () -> this.bindPropertyToConfigurationSources(name, (DynamicProperty)propertyType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), defaultValue, propertyParser));
    }

    private <T, P extends DynamicProperty<T>> P bindPropertyToConfigurationSources(String name, P property, T defaultValue, PropertyParser<T> propertyParser) {
        DynamicPropertyChain<Object> chain = this.createPropertyChain(name, defaultValue, propertyParser);
        chain.bindTo(property::setValue);
        this.notifyPropertyCreated(name, property.getCurrentValue());
        property.addListener((T newValue) -> this.notifyPropertyChanged(name, newValue));
        return property;
    }

    private <T> void notifyPropertyCreated(String propertyName, T initialValue) {
        this.dynamicConfigListenerSupport.dispatchEvent(listener -> listener.propertyCreated(propertyName, initialValue));
    }

    private <T> void notifyPropertyChanged(String propertyNAme, T newValue) {
        this.dynamicConfigListenerSupport.dispatchEvent(listener -> listener.propertyChanged(propertyNAme, newValue));
    }

    private <T> DynamicPropertyChain<T> createPropertyChain(String name, T defaultValue, PropertyParser<T> propertyParser) {
        DynamicPropertyChain<T> chain = DynamicPropertyChain.createWithDefaultValue(defaultValue, propertyParser);
        for (DynamicConfigSource configSource : this.configSources) {
            DynamicConfigProperty<T> newValueInChain = chain.appendValue();
            String propertyValue = configSource.get(name, newValueInChain);
            newValueInChain.set(propertyValue);
        }
        return chain;
    }

    public static DynamicConfig merged(DynamicConfig dynamicConfigA, DynamicConfig dynamicConfigB) {
        ArrayList<DynamicConfigSource> merged = new ArrayList<DynamicConfigSource>(dynamicConfigA.configSources.size() + dynamicConfigB.configSources.size());
        merged.addAll(dynamicConfigA.configSources);
        merged.addAll(dynamicConfigB.configSources);
        return new DynamicConfig(merged);
    }

    public String toString() {
        return this.configSources.toString();
    }

    public void addListener(DynamicConfigListener l) {
        this.dynamicConfigListenerSupport.addListener(l);
    }

    private <T extends DynamicProperty<?>> T getOrCreate(Class<T> type, String name, Callable<T> objectFactory) {
        return (T)this.configCache.computeIfAbsent(new CacheKey<T>(type, name), key -> {
            try {
                return (DynamicProperty)objectFactory.call();
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static final class CacheKey<T> {
        private final Class<T> type;
        private final String name;

        public CacheKey(Class<T> type, String name) {
            this.type = Objects.requireNonNull(type);
            this.name = name.intern();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            return this.type.equals(cacheKey.type) && this.name.equals(cacheKey.name);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.name);
        }
    }

    private static class DynamicConfigSourceAdapter
    extends AbstractDynamicConfigSource {
        private final ConfigSource configSource;

        public DynamicConfigSourceAdapter(ConfigSource configSource) {
            this.configSource = configSource;
        }

        @Override
        public String get(String propertyName, DynamicPropertyListener<String> propertyChangeListener) {
            return this.configSource.get(propertyName);
        }

        public String toString() {
            return this.configSource.toString();
        }
    }
}

