/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.DynamicPropertyListener;
import com.avanza.astrix.config.PropertyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DynamicConfigProperty<T>
implements DynamicPropertyListener<String> {
    private final Logger logger = LoggerFactory.getLogger(DynamicConfigProperty.class);
    private final DynamicPropertyListener<DynamicConfigProperty<T>> propertyChangeListener;
    private final PropertyParser<T> parser;
    private volatile T value = null;

    private DynamicConfigProperty(DynamicPropertyListener<DynamicConfigProperty<T>> propertyChangeListener, PropertyParser<T> propertyParser) {
        this.propertyChangeListener = propertyChangeListener;
        this.parser = propertyParser;
    }

    public T get() {
        return this.value;
    }

    boolean isSet() {
        return this.value != null;
    }

    public void set(String value) {
        try {
            this.value = value != null ? this.parser.parse(value) : null;
            this.propertyChangeListener.propertyChanged(this);
        }
        catch (Exception e) {
            this.logger.error("Failed to parse: {}", (Object)value, (Object)e);
        }
    }

    @Override
    public void propertyChanged(String newValue) {
        this.set(newValue);
    }

    public static <T> DynamicConfigProperty<T> create(DynamicPropertyListener<DynamicConfigProperty<T>> propertyChangeListener, PropertyParser<T> propertyParser) {
        return new DynamicConfigProperty<T>(propertyChangeListener, propertyParser);
    }
}

