/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.AbstractDynamicProperty;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class DynamicListProperty<T>
extends AbstractDynamicProperty<List<T>> {
    public DynamicListProperty() {
        super(Collections.emptyList());
    }

    public DynamicListProperty(List<T> initialValue) {
        super(Collections.unmodifiableList(initialValue));
    }

    public void set(List<T> value) {
        this.setValue(value);
    }

    @Override
    public void setValue(List<T> value) {
        super.setValue(Collections.unmodifiableList(value));
    }

    @Override
    public String toString() {
        return ((List)this.getCurrentValue()).stream().map(String::valueOf).collect(Collectors.joining(","));
    }
}

