/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.DynamicConfigProperty;
import com.avanza.astrix.config.DynamicPropertyChainListener;
import com.avanza.astrix.config.DynamicPropertyListener;
import com.avanza.astrix.config.PropertyParser;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;

final class DynamicPropertyChain<T>
implements DynamicPropertyListener<DynamicConfigProperty<T>> {
    private final Deque<DynamicConfigProperty<T>> chain = new LinkedList<DynamicConfigProperty<T>>();
    private volatile PropertyChangeEventDispatcher propertyChainListener = null;
    private final T defaultValue;
    private final PropertyParser<T> parser;

    private DynamicPropertyChain(T defaultValue, PropertyParser<T> parser) {
        this.defaultValue = defaultValue;
        this.parser = parser;
    }

    void bindTo(DynamicPropertyChainListener<T> l) {
        this.propertyChainListener = new PropertyChangeEventDispatcher(l);
        this.propertyChainListener.init();
    }

    static <T> DynamicPropertyChain<T> createWithDefaultValue(T defaultValue, PropertyParser<T> parser) {
        return new DynamicPropertyChain<T>(defaultValue, parser);
    }

    private T get() {
        return (T)this.chain.stream().filter(DynamicConfigProperty::isSet).findFirst().map(DynamicConfigProperty::get).orElse(this.defaultValue);
    }

    @Override
    public void propertyChanged(DynamicConfigProperty<T> updatedProperty) {
        PropertyChangeEventDispatcher propertyChainListener = this.propertyChainListener;
        if (propertyChainListener != null) {
            propertyChainListener.propertyChanged();
        }
    }

    DynamicConfigProperty<T> appendValue() {
        DynamicConfigProperty<T> property = DynamicConfigProperty.create(this, this.parser);
        this.chain.addLast(property);
        return property;
    }

    private class PropertyChangeEventDispatcher {
        private final DynamicPropertyChainListener<T> listener;
        private T lastNotifiedState;

        public PropertyChangeEventDispatcher(DynamicPropertyChainListener<T> listener) {
            this.listener = listener;
        }

        private void init() {
            this.propertyChanged();
        }

        private void propertyChanged() {
            Object currentResolvedValue = DynamicPropertyChain.this.get();
            if (!Objects.equals(currentResolvedValue, this.lastNotifiedState)) {
                this.listener.propertyChanged(currentResolvedValue);
                this.lastNotifiedState = currentResolvedValue;
            }
        }
    }
}

