/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.DynamicConfig;
import com.avanza.astrix.config.DynamicEnumProperty;
import com.avanza.astrix.config.Setting;
import java.util.Objects;

public class EnumSetting<T extends Enum<T>>
implements Setting<T> {
    private final String name;
    private final Class<T> enumType;
    private final T defaultValue;

    public EnumSetting(String name, Class<T> enumType, T defaultValue) {
        this.name = Objects.requireNonNull(name);
        this.enumType = Objects.requireNonNull(enumType);
        this.defaultValue = defaultValue;
    }

    public static <T extends Enum<T>> EnumSetting<T> create(String name, Class<T> enumType, T defaultValue) {
        return new EnumSetting<T>(name, enumType, defaultValue);
    }

    @Override
    public DynamicEnumProperty<T> getFrom(DynamicConfig config) {
        return config.getEnumProperty(this.name, this.enumType, this.defaultValue);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }
}

