/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.ConfigSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class GlobalConfigSourceRegistry {
    private static final AtomicLong idGen = new AtomicLong();
    private static final Map<String, ConfigSource> configSourceById = new ConcurrentHashMap<String, ConfigSource>();

    private GlobalConfigSourceRegistry() {
    }

    public static ConfigSource getConfigSource(String configSourceId) {
        return configSourceById.get(configSourceId);
    }

    public static String register(ConfigSource configSource) {
        String id = Long.toString(idGen.incrementAndGet());
        configSourceById.put(id, configSource);
        return id;
    }
}

