/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ListenerSupport<T> {
    private static final Logger log = LoggerFactory.getLogger(ListenerSupport.class);
    private final Queue<SubscribedListener> listeners = new ConcurrentLinkedQueue<SubscribedListener>();

    ListenerSupport() {
    }

    void addListener(T l) {
        this.listeners.add(new SubscribedListener(l));
    }

    void dispatchEvent(Consumer<T> eventNotification) {
        for (SubscribedListener subscribedListener : this.listeners) {
            try {
                eventNotification.accept(subscribedListener.listener);
            }
            catch (RuntimeException exception) {
                log.warn("Error when notifying listener {}", (Object)subscribedListener, (Object)exception);
            }
        }
    }

    void removeListener(T l) {
        this.listeners.remove(new SubscribedListener(l));
    }

    private class SubscribedListener {
        private final T listener;

        public SubscribedListener(T l) {
            this.listener = Objects.requireNonNull(l);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SubscribedListener) {
                return this.listener == ((SubscribedListener)obj).listener;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.listener);
        }

        public String toString() {
            return "DynamicConfigListener(" + this.listener.toString() + ")";
        }
    }
}

