/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.AbstractDynamicConfigSource;
import com.avanza.astrix.config.BooleanSetting;
import com.avanza.astrix.config.DynamicPropertyListener;
import com.avanza.astrix.config.EnumSetting;
import com.avanza.astrix.config.IntSetting;
import com.avanza.astrix.config.LongSetting;
import com.avanza.astrix.config.MutableConfigSource;
import com.avanza.astrix.config.Setting;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class MapConfigSource
extends AbstractDynamicConfigSource
implements MutableConfigSource {
    private final ConcurrentMap<String, ListenableStringProperty> propertyValues = new ConcurrentHashMap<String, ListenableStringProperty>();

    public static MapConfigSource of(Map<String, ?> source) {
        MapConfigSource configSource = new MapConfigSource();
        source.forEach((key, value) -> configSource.set((String)key, value.toString()));
        return configSource;
    }

    public static MapConfigSource of(String key, Object value) {
        MapConfigSource configSource = new MapConfigSource();
        configSource.set(key, value.toString());
        return configSource;
    }

    public static MapConfigSource of(String key1, Object value1, String key2, Object value2) {
        MapConfigSource configSource = new MapConfigSource();
        configSource.set(key1, value1.toString());
        configSource.set(key2, value2.toString());
        return configSource;
    }

    public static MapConfigSource of(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        MapConfigSource configSource = new MapConfigSource();
        configSource.set(key1, value1.toString());
        configSource.set(key2, value2.toString());
        configSource.set(key3, value3.toString());
        return configSource;
    }

    @Override
    public String get(String propertyName, DynamicPropertyListener<String> propertyChangeListener) {
        ListenableStringProperty dynamicProperty = this.getProperty(propertyName);
        dynamicProperty.listeners.add(propertyChangeListener);
        return dynamicProperty.value;
    }

    public void set(String propertyName, String value) {
        this.getProperty(propertyName).set(value);
    }

    @Override
    public <T> void set(Setting<T> setting, T value) {
        this.set(setting.name(), value == null ? null : value.toString());
    }

    @Override
    public void set(IntSetting setting, int value) {
        this.set(setting.name(), Integer.toString(value));
    }

    @Override
    public void set(LongSetting setting, long value) {
        this.set(setting.name(), Long.toString(value));
    }

    @Override
    public void set(BooleanSetting setting, boolean value) {
        this.set(setting.name(), Boolean.toString(value));
    }

    @Override
    public <T extends Enum<T>> void set(EnumSetting<T> setting, T value) {
        this.set(setting.name(), value == null ? null : value.name());
    }

    private ListenableStringProperty getProperty(String propertyName) {
        return this.propertyValues.computeIfAbsent(propertyName, key -> new ListenableStringProperty());
    }

    public void setAll(MapConfigSource config) {
        config.propertyValues.forEach((key, value) -> this.set((String)key, ((ListenableStringProperty)value).value));
    }

    public String toString() {
        return this.propertyValues.toString();
    }

    private static class ListenableStringProperty {
        private final Queue<DynamicPropertyListener<String>> listeners = new ConcurrentLinkedQueue<DynamicPropertyListener<String>>();
        private volatile String value;

        private ListenableStringProperty() {
        }

        void propertyChanged(String newValue) {
            this.listeners.forEach(l -> l.propertyChanged(newValue));
        }

        void set(String value) {
            this.value = value;
            this.propertyChanged(value);
        }

        public String toString() {
            return this.value;
        }
    }
}

