/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.ConfigSource;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigSource
implements ConfigSource {
    private static final Logger log = LoggerFactory.getLogger(PropertiesConfigSource.class);
    private final Properties properties;

    public PropertiesConfigSource(Properties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Override
    public String get(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigSource optionalClasspathPropertiesFile(String fileName) {
        Properties classpathOverride = new Properties();
        try (InputStream resourceAsStream = PropertiesConfigSource.class.getClassLoader().getResourceAsStream(fileName);){
            if (resourceAsStream == null) {
                log.info("Optional config properties file not present on classpath: {}", (Object)fileName);
                PropertiesConfigSource propertiesConfigSource = new PropertiesConfigSource(classpathOverride);
                return propertiesConfigSource;
            }
            classpathOverride.load(resourceAsStream);
            return new PropertiesConfigSource(classpathOverride);
        }
        catch (Exception e) {
            log.warn("Failed to load config properties from file: {}", (Object)fileName);
        }
        return new PropertiesConfigSource(classpathOverride);
    }

    public String toString() {
        return "PropertiesConfigSource: " + this.properties.toString();
    }
}

