/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

interface PropertyParser<T> {
    public static final PropertyParser<Boolean> BOOLEAN_PARSER = new BooleanParser();
    public static final PropertyParser<String> STRING_PARSER = new StringParser();
    public static final PropertyParser<Long> LONG_PARSER = new LongParser();
    public static final PropertyParser<Integer> INT_PARSER = new IntParser();
    public static final PropertyParser<List<Boolean>> BOOLEAN_LIST_PARSER = new ListParser<Boolean>(BOOLEAN_PARSER);
    public static final PropertyParser<List<String>> STRING_LIST_PARSER = new ListParser<String>(STRING_PARSER);
    public static final PropertyParser<List<Long>> LONG_LIST_PARSER = new ListParser<Long>(LONG_PARSER);
    public static final PropertyParser<List<Integer>> INT_LIST_PARSER = new ListParser<Integer>(INT_PARSER);

    public static <T extends Enum<T>> PropertyParser<T> enumParser(Class<T> enumClass) {
        return new EnumParser<T>(enumClass);
    }

    public static <T extends Enum<T>> PropertyParser<Set<T>> enumSetParser(Class<T> enumClass) {
        return new SetParser<T>(PropertyParser.enumParser(enumClass));
    }

    public static <T extends Enum<T>> PropertyParser<List<T>> enumListParser(Class<T> enumClass) {
        return new ListParser<T>(PropertyParser.enumParser(enumClass));
    }

    public T parse(String var1);

    public static class SetParser<T>
    extends CollectionParser<T, Set<T>> {
        SetParser(PropertyParser<T> singleValueParser) {
            super(singleValueParser, Collections::emptySet, Collectors.toCollection(LinkedHashSet::new));
        }
    }

    public static class ListParser<T>
    extends CollectionParser<T, List<T>> {
        ListParser(PropertyParser<T> singleValueParser) {
            super(singleValueParser, Collections::emptyList, Collectors.toList());
        }
    }

    public static abstract class CollectionParser<T, C extends Collection<T>>
    implements PropertyParser<C> {
        private final PropertyParser<T> singleValueParser;
        private final Supplier<C> emptyCollection;
        private final Collector<T, ?, C> toCollection;

        protected CollectionParser(PropertyParser<T> singleValueParser, Supplier<C> emptyCollection, Collector<T, ?, C> toCollection) {
            this.singleValueParser = Objects.requireNonNull(singleValueParser);
            this.emptyCollection = Objects.requireNonNull(emptyCollection);
            this.toCollection = Objects.requireNonNull(toCollection);
        }

        @Override
        public final C parse(String value) {
            String trimmed;
            String string = trimmed = value == null ? "" : value.trim();
            if (trimmed.isEmpty()) {
                return (C)((Collection)this.emptyCollection.get());
            }
            return (C)((Collection)Arrays.stream(trimmed.split(",")).map(String::trim).map(this.singleValueParser::parse).collect(this.toCollection));
        }
    }

    public static class EnumParser<T extends Enum<T>>
    implements PropertyParser<T> {
        private final Class<T> enumClass;

        public EnumParser(Class<T> enumClass) {
            this.enumClass = Objects.requireNonNull(enumClass);
        }

        @Override
        public T parse(String value) {
            return (T)Arrays.stream((Enum[])this.enumClass.getEnumConstants()).filter(it -> it.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown " + this.enumClass.getSimpleName() + " value " + value));
        }
    }

    public static class IntParser
    implements PropertyParser<Integer> {
        @Override
        public Integer parse(String value) {
            return Integer.valueOf(value);
        }
    }

    public static class LongParser
    implements PropertyParser<Long> {
        @Override
        public Long parse(String value) {
            return Long.valueOf(value);
        }
    }

    public static class StringParser
    implements PropertyParser<String> {
        @Override
        public String parse(String value) {
            return value;
        }
    }

    public static class BooleanParser
    implements PropertyParser<Boolean> {
        @Override
        public Boolean parse(String value) {
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            throw new IllegalArgumentException("Cannot parse boolean value: \"" + value + "\"");
        }
    }
}

