/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.astrix.config;

import com.avanza.astrix.config.DynamicConfig;
import com.avanza.astrix.config.DynamicStringProperty;
import com.avanza.astrix.config.Setting;
import java.util.Objects;

public class StringSetting
implements Setting<String> {
    private final String name;
    private final String defaultValue;

    public StringSetting(String name, String defaultValue) {
        this.name = Objects.requireNonNull(name);
        this.defaultValue = defaultValue;
    }

    public static StringSetting create(String name, String defaultValue) {
        return new StringSetting(name, defaultValue);
    }

    public DynamicStringProperty getFrom(DynamicConfig config) {
        return config.getStringProperty(this.name, this.defaultValue);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }
}

