/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.ymer;

import com.avanza.ymer.MirroredObjectDefinition;
import com.avanza.ymer.MirroredObjectTestHelper;
import com.avanza.ymer.MirroredObjectsConfiguration;
import com.avanza.ymer.TestDocumentConverter;
import com.avanza.ymer.YmerFactory;
import com.avanza.ymer.test.SpaceClassTestHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.matcher.AssertionMatcher;
import org.bson.Document;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.NoOpDbRefResolver;

@RunWith(value=Parameterized.class)
public abstract class YmerConverterTestBase {
    private final ConverterTest testCase;

    public YmerConverterTestBase(ConverterTest<?> testCase) {
        this.testCase = testCase;
    }

    @Test
    public void serializationTest() {
        Object spaceObject = this.testCase.spaceObject;
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectHelper(spaceObject.getClass());
        TestDocumentConverter documentConverter = TestDocumentConverter.create((MongoConverter)this.createMongoConverter());
        Document basicDBObject = documentConverter.convertToBsonDocument(spaceObject);
        Object reCreated = documentConverter.convert(mirroredDocument.getMirroredType(), basicDBObject);
        MatcherAssert.assertThat((Object)reCreated, this.testCase.matcher);
    }

    @Test
    public void canMirrorSpaceObject() {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectHelper(this.testCase.spaceObject.getClass());
        Assert.assertTrue((String)("Mirroring of " + this.testCase.getClass()), (boolean)mirroredDocument.isMirroredType());
    }

    @Test
    public void testFailsIfSpringDataIdAnnotationNotDefinedForSpaceObject() {
        Object spaceObject = this.testCase.spaceObject;
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectHelper(spaceObject.getClass());
        TestDocumentConverter documentConverter = TestDocumentConverter.create((MongoConverter)this.createMongoConverter());
        SpaceClassTestHelper.ensureSpaceId(spaceObject);
        Document basicDBObject = documentConverter.convertToBsonDocument(spaceObject);
        Object reCreated = documentConverter.convert(mirroredDocument.getMirroredType(), basicDBObject);
        Document recreatedBasicDbObject = documentConverter.convertToBsonDocument(reCreated);
        Assert.assertNotNull((String)"No id field defined. @SpaceId annotations are ignored by persistence framework, use @Id for id field (Typically the same as is annotated with @SpaceId)", (Object)recreatedBasicDbObject.get((Object)"_id"));
        Assert.assertEquals((Object)basicDBObject.get((Object)"_id"), (Object)recreatedBasicDbObject.get((Object)"_id"));
    }

    @Test
    public void testFailsIfCollectionOrMapPropertyOfTestSubjectIsEmpty() throws Exception {
        Object spaceObject = this.testCase.spaceObject;
        Field[] fields = spaceObject.getClass().getDeclaredFields();
        LinkedList<String> emptyFields = new LinkedList<String>();
        for (Field field : fields) {
            field.setAccessible(true);
            Object fieldValue = field.get(spaceObject);
            if (fieldValue instanceof Collection && ((Collection)fieldValue).isEmpty()) {
                emptyFields.add(field.getName());
            }
            if (!(fieldValue instanceof Map) || !((Map)fieldValue).isEmpty()) continue;
            emptyFields.add(field.getName());
        }
        Assert.assertTrue((String)("Test subject of class " + spaceObject.getClass().getCanonicalName() + " has empty collections/map, add at least one element to ensure proper test coverage.: " + emptyFields), (boolean)emptyFields.isEmpty());
    }

    @Test
    public void shouldRequireAnnotationsOnCustomConverters() {
        for (Converter customConverter : this.getMirroredObjectsConfiguration().getCustomConverters()) {
            boolean hasWritingConverterAnnotation;
            boolean hasReadingConverterAnnotation = customConverter.getClass().getAnnotation(ReadingConverter.class) != null;
            boolean bl = hasWritingConverterAnnotation = customConverter.getClass().getAnnotation(WritingConverter.class) != null;
            if (hasReadingConverterAnnotation || hasWritingConverterAnnotation) continue;
            Assert.fail((String)("Custom converter=[" + customConverter.getClass() + "] should be annotated with either @ReadingConverter or @WritingConverter"));
        }
    }

    private MirroredObjectTestHelper getMirroredObjectHelper(Class<?> objectClass) {
        return MirroredObjectTestHelper.fromDefinitions(this.getMirroredObjectDefinitions(), objectClass);
    }

    protected Collection<MirroredObjectDefinition<?>> getMirroredObjectDefinitions() {
        return this.getMirroredObjectsConfiguration().getMirroredObjectDefinitions();
    }

    protected CustomConversions getCustomConversions() {
        return new MongoCustomConversions(this.getMirroredObjectsConfiguration().getCustomConverters());
    }

    protected abstract MirroredObjectsConfiguration getMirroredObjectsConfiguration();

    private MongoConverter createMongoConverter() {
        return YmerFactory.createMongoConverter((DbRefResolver)NoOpDbRefResolver.INSTANCE, (CustomConversions)this.getCustomConversions());
    }

    protected static List<Object[]> buildTestCases(ConverterTest<?> ... list) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (ConverterTest<?> testCase : list) {
            result.add(new Object[]{testCase});
        }
        return result;
    }

    protected static class ConverterTest<T> {
        final T spaceObject;
        final Matcher<T> matcher;

        public ConverterTest(final T spaceObject) {
            this(spaceObject, (Matcher<T>)new AssertionMatcher<T>(){

                public void assertion(T deserializedObject) throws AssertionError {
                    Assertions.assertThat(deserializedObject).usingRecursiveComparison().isEqualTo(spaceObject);
                }
            });
        }

        public ConverterTest(T spaceObject, Matcher<T> matcher) {
            this.spaceObject = spaceObject;
            this.matcher = matcher;
        }
    }
}

