/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.ymer;

import com.avanza.ymer.MirroredObjectDefinition;
import com.avanza.ymer.MirroredObjectTestHelper;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class YmerMigrationTestBase {
    private final MigrationTest migrationTest;

    public YmerMigrationTestBase(MigrationTest testCase) {
        this.migrationTest = testCase;
    }

    @Test
    public void migratesTheOldDocumentToTheNextDocumentVersion() {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectsHelper(this.migrationTest.spaceObjectType);
        mirroredDocument.setDocumentVersion(this.migrationTest.toBePatched, this.migrationTest.fromVersion);
        Document patched = new Document((Map)this.migrationTest.toBePatched);
        mirroredDocument.patchToNextVersion(patched);
        mirroredDocument.setDocumentVersion(this.migrationTest.expectedPatchedVersion, this.migrationTest.fromVersion + 1);
        Assert.assertEquals((Object)this.migrationTest.expectedPatchedVersion, (Object)patched);
        Assert.assertEquals((long)(this.migrationTest.fromVersion + 1), (long)mirroredDocument.getDocumentVersion(patched));
    }

    @Test
    public void oldVersionShouldRequirePatching() {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectsHelper(this.migrationTest.spaceObjectType);
        mirroredDocument.setDocumentVersion(this.migrationTest.toBePatched, this.migrationTest.fromVersion);
        Assert.assertTrue((String)("Should require patching: " + this.migrationTest.toBePatched), (boolean)mirroredDocument.requiresPatching(this.migrationTest.toBePatched));
    }

    @Test
    public void targetSpaceTypeShouldBeAMirroredType() {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectsHelper(this.migrationTest.spaceObjectType);
        Assert.assertTrue((String)("Mirroring of " + this.migrationTest.getClass()), (boolean)mirroredDocument.isMirroredType());
    }

    private MirroredObjectTestHelper getMirroredObjectsHelper(Class<?> mirroredType) {
        return MirroredObjectTestHelper.fromDefinitions(this.getMirroredObjectDefinitions(), mirroredType);
    }

    protected abstract Collection<MirroredObjectDefinition<?>> getMirroredObjectDefinitions();

    protected static List<Object[]> buildTestCases(MigrationTest ... list) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (MigrationTest testCase : list) {
            result.add(new Object[]{testCase});
        }
        return result;
    }

    protected static class MigrationTest {
        final Document toBePatched;
        final Document expectedPatchedVersion;
        final int fromVersion;
        final Class<?> spaceObjectType;

        public MigrationTest(Document oldVersionDoc, Document expectedPatchedVersion, int oldVersion, Class<?> spaceObjectType) {
            this.toBePatched = oldVersionDoc;
            this.expectedPatchedVersion = expectedPatchedVersion;
            this.fromVersion = oldVersion;
            this.spaceObjectType = spaceObjectType;
        }

        @Deprecated
        public MigrationTest(BasicDBObject oldVersionDoc, BasicDBObject expectedPatchedVersion, int oldVersion, Class<?> spaceObjectType) {
            this(new Document((Map)oldVersionDoc), new Document((Map)expectedPatchedVersion), oldVersion, spaceObjectType);
        }
    }
}

