/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.ymer.test;

import com.avanza.ymer.MirroredObjectDefinition;
import com.avanza.ymer.MirroredObjectTestHelper;
import com.avanza.ymer.MirroredObjectsConfiguration;
import com.avanza.ymer.TestDocumentConverter;
import com.avanza.ymer.YmerFactoryTestHelper;
import com.avanza.ymer.test.SpaceClassTestHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.matcher.AssertionMatcher;
import org.bson.Document;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.NoOpDbRefResolver;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class YmerConverterTestBase {
    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void serializationTest(ConverterTest testCase) {
        Object spaceObject = testCase.spaceObject;
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectHelper(spaceObject.getClass());
        TestDocumentConverter documentConverter = TestDocumentConverter.create((MongoConverter)this.createMongoConverter());
        Document basicDBObject = documentConverter.convertToBsonDocument(spaceObject);
        Object reCreated = documentConverter.convert(mirroredDocument.getMirroredType(), basicDBObject);
        MatcherAssert.assertThat((Object)reCreated, testCase.matcher);
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void canMirrorSpaceObject(ConverterTest<?> testCase) {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectHelper(testCase.spaceObject.getClass());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)mirroredDocument.isMirroredType(), (String)("Mirroring of " + testCase.getClass()));
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void testFailsIfSpringDataIdAnnotationNotDefinedForSpaceObject(ConverterTest<?> testCase) {
        Object spaceObject = testCase.spaceObject;
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectHelper(spaceObject.getClass());
        TestDocumentConverter documentConverter = TestDocumentConverter.create((MongoConverter)this.createMongoConverter());
        SpaceClassTestHelper.ensureSpaceId(spaceObject);
        Document basicDBObject = documentConverter.convertToBsonDocument(spaceObject);
        Object reCreated = documentConverter.convert(mirroredDocument.getMirroredType(), basicDBObject);
        Document recreatedBasicDbObject = documentConverter.convertToBsonDocument(reCreated);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)recreatedBasicDbObject.get((Object)"_id"), (String)"No id field defined. @SpaceId annotations are ignored by persistence framework, use @Id for id field (Typically the same as is annotated with @SpaceId)");
        org.junit.jupiter.api.Assertions.assertEquals((Object)basicDBObject.get((Object)"_id"), (Object)recreatedBasicDbObject.get((Object)"_id"));
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void testFailsIfCollectionOrMapPropertyOfTestSubjectIsEmpty(ConverterTest<?> testCase) throws Exception {
        Object spaceObject = testCase.spaceObject;
        Field[] fields = spaceObject.getClass().getDeclaredFields();
        LinkedList<String> emptyFields = new LinkedList<String>();
        for (Field field : fields) {
            field.setAccessible(true);
            Object fieldValue = field.get(spaceObject);
            if (fieldValue instanceof Collection && ((Collection)fieldValue).isEmpty()) {
                emptyFields.add(field.getName());
            }
            if (!(fieldValue instanceof Map) || !((Map)fieldValue).isEmpty()) continue;
            emptyFields.add(field.getName());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)emptyFields.isEmpty(), (String)("Test subject of class " + spaceObject.getClass().getCanonicalName() + " has empty collections/map, add at least one element to ensure proper test coverage.: " + emptyFields));
    }

    @Test
    public void shouldRequireAnnotationsOnCustomConverters() {
        for (Converter customConverter : this.getMirroredObjectsConfiguration().getCustomConverters()) {
            boolean hasWritingConverterAnnotation;
            boolean hasReadingConverterAnnotation = customConverter.getClass().getAnnotation(ReadingConverter.class) != null;
            boolean bl = hasWritingConverterAnnotation = customConverter.getClass().getAnnotation(WritingConverter.class) != null;
            if (hasReadingConverterAnnotation || hasWritingConverterAnnotation) continue;
            org.junit.jupiter.api.Assertions.fail((String)("Custom converter=[" + customConverter.getClass() + "] should be annotated with either @ReadingConverter or @WritingConverter"));
        }
    }

    private MirroredObjectTestHelper getMirroredObjectHelper(Class<?> objectClass) {
        return MirroredObjectTestHelper.fromDefinitions(this.getMirroredObjectDefinitions(), objectClass);
    }

    protected Collection<MirroredObjectDefinition<?>> getMirroredObjectDefinitions() {
        return this.getMirroredObjectsConfiguration().getMirroredObjectDefinitions();
    }

    protected CustomConversions getCustomConversions() {
        return new MongoCustomConversions(this.getMirroredObjectsConfiguration().getCustomConverters());
    }

    protected abstract MirroredObjectsConfiguration getMirroredObjectsConfiguration();

    private MongoConverter createMongoConverter() {
        return YmerFactoryTestHelper.createMongoConverter((DbRefResolver)NoOpDbRefResolver.INSTANCE, this.getCustomConversions());
    }

    protected abstract Collection<ConverterTest<?>> testCases();

    protected static class ConverterTest<T> {
        final T spaceObject;
        final Matcher<T> matcher;

        public ConverterTest(final T spaceObject) {
            this(spaceObject, (Matcher<T>)new AssertionMatcher<T>(){

                public void assertion(T deserializedObject) throws AssertionError {
                    Assertions.assertThat(deserializedObject).usingRecursiveComparison().isEqualTo(spaceObject);
                }
            });
        }

        public ConverterTest(T spaceObject, Matcher<T> matcher) {
            this.spaceObject = spaceObject;
            this.matcher = matcher;
        }

        public String toString() {
            return "ConverterTest: " + this.spaceObject.getClass();
        }
    }
}

