/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.ymer.test;

import com.avanza.ymer.MirroredObjectDefinition;
import com.avanza.ymer.MirroredObjectTestHelper;
import java.util.Collection;
import java.util.Map;
import org.bson.Document;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class YmerMigrationTestBase {
    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void migratesTheOldDocumentToTheNextDocumentVersion(MigrationTest migrationTest) {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectsHelper(migrationTest.spaceObjectType);
        mirroredDocument.setDocumentVersion(migrationTest.toBePatched, migrationTest.fromVersion);
        Document patched = new Document((Map)migrationTest.toBePatched);
        mirroredDocument.patchToNextVersion(patched);
        mirroredDocument.setDocumentVersion(migrationTest.expectedPatchedVersion, migrationTest.fromVersion + 1);
        Assertions.assertEquals((Object)migrationTest.expectedPatchedVersion, (Object)patched);
        Assertions.assertEquals((int)(migrationTest.fromVersion + 1), (int)mirroredDocument.getDocumentVersion(patched));
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void oldVersionShouldRequirePatching(MigrationTest migrationTest) {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectsHelper(migrationTest.spaceObjectType);
        mirroredDocument.setDocumentVersion(migrationTest.toBePatched, migrationTest.fromVersion);
        Assertions.assertTrue((boolean)mirroredDocument.requiresPatching(migrationTest.toBePatched), (String)("Should require patching: " + migrationTest.toBePatched));
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void targetSpaceTypeShouldBeAMirroredType(MigrationTest migrationTest) {
        MirroredObjectTestHelper mirroredDocument = this.getMirroredObjectsHelper(migrationTest.spaceObjectType);
        Assertions.assertTrue((boolean)mirroredDocument.isMirroredType(), (String)("Mirroring of " + migrationTest.getClass()));
    }

    private MirroredObjectTestHelper getMirroredObjectsHelper(Class<?> mirroredType) {
        return MirroredObjectTestHelper.fromDefinitions(this.getMirroredObjectDefinitions(), mirroredType);
    }

    protected abstract Collection<MirroredObjectDefinition<?>> getMirroredObjectDefinitions();

    protected abstract Collection<MigrationTest> testCases();

    protected static class MigrationTest {
        final Document toBePatched;
        final Document expectedPatchedVersion;
        final int fromVersion;
        final Class<?> spaceObjectType;

        public MigrationTest(Document oldVersionDoc, Document expectedPatchedVersion, int oldVersion, Class<?> spaceObjectType) {
            this.toBePatched = oldVersionDoc;
            this.expectedPatchedVersion = expectedPatchedVersion;
            this.fromVersion = oldVersion;
            this.spaceObjectType = spaceObjectType;
        }

        public String toString() {
            return "MigrationTest: " + this.spaceObjectType;
        }
    }
}

