/*
 * Decompiled with CFR 0.152.
 */
package com.avanza.ymer.test;

import com.avanza.ymer.MirroredObjectDefinition;
import com.gigaspaces.annotation.pojo.SpaceClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class YmerMirroredTypesTestBase {
    @Test
    void allSpaceClassesAreIncludedInYmerFactory() {
        Set mirroredClassNames = this.mirroredObjectDefinitions().stream().map(mirroredObject -> mirroredObject.getMirroredType().getName()).collect(Collectors.toSet());
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SpaceClass.class));
        ArrayList<String> spaceClassesWithoutMirrorDefinition = new ArrayList<String>();
        for (BeanDefinition bd : scanner.findCandidateComponents(this.basePackageForScanning())) {
            String spaceClassName = bd.getBeanClassName();
            if (mirroredClassNames.contains(spaceClassName) || this.getClassesToExclude().contains(spaceClassName)) continue;
            spaceClassesWithoutMirrorDefinition.add(spaceClassName);
        }
        if (!spaceClassesWithoutMirrorDefinition.isEmpty()) {
            StringBuilder failMessageBuilder = new StringBuilder("The following classes are defined as @SpaceClass without having a mirrored object definition:\n");
            spaceClassesWithoutMirrorDefinition.forEach(c -> failMessageBuilder.append((String)c).append('\n'));
            failMessageBuilder.append('\n').append("This means that objects of these classes would not be persisted to database by Ymer.");
            failMessageBuilder.append('\n').append("To resolve this, add the SpaceClass to the mirrored object definitions.");
            failMessageBuilder.append('\n').append("Alternatively, if the class is intended to not be persisted, override spaceClassesToExcludeFromTest() to exclude the class from this test.");
            Assertions.fail((String)failMessageBuilder.toString());
        }
    }

    private Set<String> getClassesToExclude() {
        return this.spaceClassesToExcludeFromTest().stream().map(Class::getName).collect(Collectors.toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"mirroredObjectDefinitions"})
    void mirroredTypeIsAnnotatedWithSpaceClass(MirroredObjectDefinition<?> mirroredObjectDefinition) {
        boolean hasSpaceClassAnnotation;
        Class mirroredType = mirroredObjectDefinition.getMirroredType();
        boolean bl = hasSpaceClassAnnotation = mirroredType.getAnnotation(SpaceClass.class) != null;
        if (!hasSpaceClassAnnotation) {
            String failMessage = "The following class is included in Ymer mirrored object definitions but not annotated with @SpaceClass:\n" + mirroredType.getName() + "\n\nAll classes marked for persisting through Ymer should be annotated with @SpaceClass.\nTo resolve this, annotate this class above with @SpaceClass.";
            Assertions.fail((String)failMessage);
        }
    }

    protected abstract Collection<MirroredObjectDefinition<?>> mirroredObjectDefinitions();

    protected abstract String basePackageForScanning();

    protected Set<Class<?>> spaceClassesToExcludeFromTest() {
        return Collections.emptySet();
    }
}

