/*
 * Decompiled with CFR 0.152.
 */
package com.avast.gradle.dockercompose;

import com.avast.gradle.dockercompose.ComposeExecutor;
import com.avast.gradle.dockercompose.ContainerInfo;
import com.avast.gradle.dockercompose.DockerExecutor;
import com.avast.gradle.dockercompose.RemoveImages;
import com.avast.gradle.dockercompose.ServiceInfo;
import com.avast.gradle.dockercompose.tasks.ComposeBuild;
import com.avast.gradle.dockercompose.tasks.ComposeDown;
import com.avast.gradle.dockercompose.tasks.ComposeDownForced;
import com.avast.gradle.dockercompose.tasks.ComposeLogs;
import com.avast.gradle.dockercompose.tasks.ComposePull;
import com.avast.gradle.dockercompose.tasks.ComposePush;
import com.avast.gradle.dockercompose.tasks.ComposeUp;
import com.avast.gradle.dockercompose.tasks.ServiceInfoCache;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.util.VersionNumber;

public abstract class ComposeSettings
implements GroovyObject {
    private final TaskProvider<ComposeUp> upTask;
    private final TaskProvider<ComposeDown> downTask;
    private final TaskProvider<ComposeDownForced> downForcedTask;
    private final TaskProvider<ComposeBuild> buildTask;
    private final TaskProvider<ComposePull> pullTask;
    private final TaskProvider<ComposeLogs> logsTask;
    private final TaskProvider<ComposePush> pushTask;
    private final Project project;
    private final DockerExecutor dockerExecutor;
    private final ComposeExecutor composeExecutor;
    private final ServiceInfoCache serviceInfoCache;
    private boolean buildBeforeUp;
    private boolean buildBeforePull;
    private boolean waitForTcpPorts;
    private List<Integer> tcpPortsToIgnoreWhenWaiting;
    private Duration waitAfterTcpProbeFailure;
    private Duration waitForTcpPortsTimeout;
    private Duration waitForTcpPortsDisconnectionProbeTimeout;
    private Duration waitAfterHealthyStateProbeFailure;
    private Duration waitForHealthyStateTimeout;
    private boolean checkContainersRunning;
    private List<String> useComposeFiles;
    private boolean captureContainersOutput;
    private File captureContainersOutputToFile;
    private File captureContainersOutputToFiles;
    private File composeLogToFile;
    private File containerLogToDir;
    private List<String> startedServices;
    private Map<String, Integer> scale;
    private boolean removeOrphans;
    private boolean forceRecreate;
    private boolean noRecreate;
    private List<String> buildAdditionalArgs;
    private List<String> pullAdditionalArgs;
    private List<String> upAdditionalArgs;
    private List<String> downAdditionalArgs;
    private List<String> composeAdditionalArgs;
    protected String customProjectName;
    protected Boolean customProjectNameSet;
    private String projectNamePrefix;
    private String nestedName;
    private boolean stopContainers;
    private boolean removeContainers;
    private boolean retainContainersOnStartupFailure;
    private RemoveImages removeImages;
    private boolean removeVolumes;
    private boolean includeDependencies;
    private boolean ignorePullFailure;
    private boolean ignorePushFailure;
    private List<String> pushServices;
    private String executable;
    private Map<String, Object> environment;
    private String dockerExecutable;
    private String dockerComposeWorkingDirectory;
    private Duration dockerComposeStopTimeout;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Inject
    public ComposeSettings(Project project, String name, String parentName) {
        File file;
        ServiceInfoCache serviceInfoCache;
        TaskProvider taskProvider;
        TaskProvider taskProvider2;
        TaskProvider taskProvider3;
        TaskProvider taskProvider4;
        TaskProvider taskProvider5;
        TaskProvider taskProvider6;
        TaskProvider taskProvider7;
        String string;
        Project project2;
        MetaClass metaClass;
        Duration duration;
        String string2;
        String string3;
        List list;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        RemoveImages removeImages;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        boolean bl8;
        boolean bl9;
        boolean bl10;
        Map map;
        List list7;
        boolean bl11;
        List list8;
        boolean bl12;
        Duration duration2;
        Duration duration3;
        Duration duration4;
        Duration duration5;
        Duration duration6;
        List list9;
        boolean bl13;
        boolean bl14;
        boolean bl15;
        this.buildBeforeUp = bl15 = true;
        this.buildBeforePull = bl14 = true;
        this.waitForTcpPorts = bl13 = true;
        this.tcpPortsToIgnoreWhenWaiting = list9 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.waitAfterTcpProbeFailure = duration6 = Duration.ofSeconds(1);
        this.waitForTcpPortsTimeout = duration5 = Duration.ofMinutes(15);
        this.waitForTcpPortsDisconnectionProbeTimeout = duration4 = Duration.ofMillis(1000);
        this.waitAfterHealthyStateProbeFailure = duration3 = Duration.ofSeconds(5);
        this.waitForHealthyStateTimeout = duration2 = Duration.ofMinutes(15);
        this.checkContainersRunning = bl12 = true;
        this.useComposeFiles = list8 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.captureContainersOutput = bl11 = false;
        Object var16_16 = null;
        this.captureContainersOutputToFile = (File)ScriptBytecodeAdapter.castToType(var16_16, File.class);
        Object var17_17 = null;
        this.captureContainersOutputToFiles = (File)ScriptBytecodeAdapter.castToType(var17_17, File.class);
        Object var18_18 = null;
        this.composeLogToFile = (File)ScriptBytecodeAdapter.castToType(var18_18, File.class);
        this.startedServices = list7 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.scale = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.removeOrphans = bl10 = false;
        this.forceRecreate = bl9 = false;
        this.noRecreate = bl8 = false;
        this.buildAdditionalArgs = list6 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.pullAdditionalArgs = list5 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.upAdditionalArgs = list4 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.downAdditionalArgs = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.composeAdditionalArgs = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.stopContainers = bl7 = true;
        this.removeContainers = bl6 = true;
        this.retainContainersOnStartupFailure = bl5 = false;
        this.removeImages = removeImages = RemoveImages.None;
        this.removeVolumes = bl4 = true;
        this.includeDependencies = bl3 = false;
        this.ignorePullFailure = bl2 = false;
        this.ignorePushFailure = bl = false;
        this.pushServices = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.executable = string3 = "docker-compose";
        HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
        this.environment = hashMap;
        this.dockerExecutable = string2 = "docker";
        Object var41_41 = null;
        this.dockerComposeWorkingDirectory = ShortTypeHandling.castToString(var41_41);
        this.dockerComposeStopTimeout = duration = Duration.ofSeconds(10);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = project2 = project;
        this.nestedName = string = StringGroovyMethods.plus((String)parentName, (CharSequence)name);
        this.upTask = taskProvider7 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeUp"}).toString() : "composeUp", ComposeUp.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure1(this, this)), Action.class));
        this.buildTask = taskProvider6 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeBuild"}).toString() : "composeBuild", ComposeBuild.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure2(this, this)), Action.class));
        this.pullTask = taskProvider5 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposePull"}).toString() : "composePull", ComposePull.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure3(this, this)), Action.class));
        this.downTask = taskProvider4 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeDown"}).toString() : "composeDown", ComposeDown.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure4(this, this)), Action.class));
        this.downForcedTask = taskProvider3 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeDownForced"}).toString() : "composeDownForced", ComposeDownForced.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure5(this, this)), Action.class));
        this.logsTask = taskProvider2 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeLogs"}).toString() : "composeLogs", ComposeLogs.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure6(this, this)), Action.class));
        this.pushTask = taskProvider = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposePush"}).toString() : "composePush", ComposePush.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure7(this, this)), Action.class));
        Object object = project.getObjects().newInstance(DockerExecutor.class, new Object[]{this});
        this.dockerExecutor = (DockerExecutor)ScriptBytecodeAdapter.castToType((Object)object, DockerExecutor.class);
        Object object2 = project.getObjects().newInstance(ComposeExecutor.class, new Object[]{this});
        this.composeExecutor = (ComposeExecutor)ScriptBytecodeAdapter.castToType((Object)object2, ComposeExecutor.class);
        this.serviceInfoCache = serviceInfoCache = new ServiceInfoCache(this);
        this.containerLogToDir = file = project.getBuildDir().toPath().resolve("containers-logs").toFile();
        if (OperatingSystem.current().isMacOsX()) {
            String string4;
            String string5;
            this.executable = string5 = "/usr/local/bin/docker-compose";
            this.dockerExecutable = string4 = "/usr/local/bin/docker";
        }
    }

    @Generated
    public ComposeSettings(Project project, String name) {
        this(project, name, "");
    }

    @Generated
    public ComposeSettings(Project project) {
        this(project, "", "");
    }

    public void setProjectName(String customProjectName) {
        String string;
        this.customProjectName = string = customProjectName;
        boolean bl = true;
        this.customProjectNameSet = bl;
    }

    public String getProjectName() {
        Boolean bl = this.customProjectNameSet;
        if (bl == null ? false : bl) {
            return this.customProjectName;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.projectNamePrefix)) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.projectNamePrefix, this.nestedName}, new String[]{"", "_", ""}));
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ComposeSettings.generateSafeProjectNamePrefix(this.project), this.nestedName}, new String[]{"", "_", ""}));
    }

    private static String generateSafeProjectNamePrefix(Project project) {
        String fullPathMd5 = EncodingGroovyMethods.encodeHex((byte[])MessageDigest.getInstance("MD5").digest(project.getProjectDir().getAbsolutePath().toString().getBytes(StandardCharsets.UTF_8))).toString();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fullPathMd5, project.getName()}, new String[]{"", "_", ""}));
    }

    protected ComposeSettings cloneAsNested(String name) {
        ComposeSettings r = (ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.project.getObjects().newInstance(ComposeSettings.class, new Object[]{this.project, name, this.nestedName}), ComposeSettings.class);
        boolean bl = this.buildBeforeUp;
        r.setBuildBeforeUp(bl);
        boolean bl2 = this.buildBeforePull;
        r.setBuildBeforePull(bl2);
        boolean bl3 = this.waitForTcpPorts;
        r.setWaitForTcpPorts(bl3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.tcpPortsToIgnoreWhenWaiting);
        r.setTcpPortsToIgnoreWhenWaiting(arrayList);
        Duration duration = this.waitAfterTcpProbeFailure;
        r.setWaitAfterTcpProbeFailure(duration);
        Duration duration2 = this.waitForTcpPortsTimeout;
        r.setWaitForTcpPortsTimeout(duration2);
        Duration duration3 = this.waitForTcpPortsDisconnectionProbeTimeout;
        r.setWaitForTcpPortsDisconnectionProbeTimeout(duration3);
        Duration duration4 = this.waitAfterHealthyStateProbeFailure;
        r.setWaitAfterHealthyStateProbeFailure(duration4);
        Duration duration5 = this.waitForHealthyStateTimeout;
        r.setWaitForHealthyStateTimeout(duration5);
        boolean bl4 = this.checkContainersRunning;
        r.setCheckContainersRunning(bl4);
        boolean bl5 = this.captureContainersOutput;
        r.setCaptureContainersOutput(bl5);
        boolean bl6 = this.removeOrphans;
        r.setRemoveOrphans(bl6);
        boolean bl7 = this.forceRecreate;
        r.setForceRecreate(bl7);
        boolean bl8 = this.noRecreate;
        r.setNoRecreate(bl8);
        ArrayList<String> arrayList2 = new ArrayList<String>(this.buildAdditionalArgs);
        r.setBuildAdditionalArgs(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>(this.pullAdditionalArgs);
        r.setPullAdditionalArgs(arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>(this.upAdditionalArgs);
        r.setUpAdditionalArgs(arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>(this.downAdditionalArgs);
        r.setDownAdditionalArgs(arrayList5);
        ArrayList<String> arrayList6 = new ArrayList<String>(this.composeAdditionalArgs);
        r.setComposeAdditionalArgs(arrayList6);
        String string = this.projectNamePrefix;
        r.setProjectNamePrefix(string);
        boolean bl9 = this.stopContainers;
        r.setStopContainers(bl9);
        boolean bl10 = this.removeContainers;
        r.setRemoveContainers(bl10);
        boolean bl11 = this.retainContainersOnStartupFailure;
        r.setRetainContainersOnStartupFailure(bl11);
        RemoveImages removeImages = this.removeImages;
        r.setRemoveImages(removeImages);
        boolean bl12 = this.removeVolumes;
        r.setRemoveVolumes(bl12);
        boolean bl13 = this.includeDependencies;
        r.setIncludeDependencies(bl13);
        boolean bl14 = this.ignorePullFailure;
        r.setIgnorePullFailure(bl14);
        boolean bl15 = this.ignorePushFailure;
        r.setIgnorePushFailure(bl15);
        String string2 = this.executable;
        r.setExecutable(string2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.environment);
        r.setEnvironment(hashMap);
        String string3 = this.dockerExecutable;
        r.setDockerExecutable(string3);
        String string4 = this.dockerComposeWorkingDirectory;
        r.setDockerComposeWorkingDirectory(string4);
        Duration duration6 = this.dockerComposeStopTimeout;
        r.setDockerComposeStopTimeout(duration6);
        return r;
    }

    void isRequiredByCore(Task task, boolean fromConfigure) {
        Reference task2 = new Reference((Object)task);
        Reference fromConfigure2 = new Reference((Object)fromConfigure);
        ((Task)task2.get()).dependsOn(new Object[]{this.upTask});
        ((Task)task2.get()).finalizedBy(new Object[]{this.downTask});
        public final class _isRequiredByCore_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isRequiredByCore_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Task.class.isAssignableFrom(it.getClass()) && ((Task)ScriptBytecodeAdapter.castToType((Object)it, Task.class)).getName().toLowerCase().contains("classes");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _isRequiredByCore_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fromConfigure;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isRequiredByCore_closure9(Object _outerInstance, Object _thisObject, Reference fromConfigure) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fromConfigure = reference = fromConfigure;
            }

            public Object doCall(Object classesTask) {
                Reference classesTask2 = new Reference(classesTask);
                if (DefaultTypeTransformation.booleanUnbox((Object)this.fromConfigure.get())) {
                    return ((ComposeUp)((Object)((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).getUpTask().get())).shouldRunAfter(new Object[]{classesTask2.get()});
                }
                public final class _closure19
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference classesTask;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure19(Object _outerInstance, Object _thisObject, Reference classesTask) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.classesTask = reference = classesTask;
                    }

                    public Object doCall(Object it) {
                        return ((ComposeUp)((Object)it)).shouldRunAfter(new Object[]{this.classesTask.get()});
                    }

                    @Generated
                    public Object getClassesTask() {
                        return this.classesTask.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure19.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).getUpTask().configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure19((Object)this, this.getThisObject(), classesTask2)), Action.class));
                return null;
            }

            @Generated
            public boolean getFromConfigure() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.fromConfigure.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)this.project.getTasks().findAll((Closure)new _isRequiredByCore_closure8(this, this)), (Closure)new _isRequiredByCore_closure9(this, this, fromConfigure2));
        if ((Task)task2.get() instanceof ProcessForkOptions) {
            public final class _isRequiredByCore_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference task;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _isRequiredByCore_closure10(Object _outerInstance, Object _thisObject, Reference task) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.task = reference = task;
                }

                public Object doCall(Object it) {
                    ((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).exposeAsEnvironment((ProcessForkOptions)ScriptBytecodeAdapter.asType((Object)this.task.get(), ProcessForkOptions.class));
                    return null;
                }

                @Generated
                public Task getTask() {
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ((Task)task2.get()).doFirst((Closure)new _isRequiredByCore_closure10(this, this, task2));
        }
        if ((Task)task2.get() instanceof JavaForkOptions) {
            public final class _isRequiredByCore_closure11
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference task;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _isRequiredByCore_closure11(Object _outerInstance, Object _thisObject, Reference task) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.task = reference = task;
                }

                public Object doCall(Object it) {
                    ((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).exposeAsSystemProperties((JavaForkOptions)ScriptBytecodeAdapter.asType((Object)this.task.get(), JavaForkOptions.class));
                    return null;
                }

                @Generated
                public Task getTask() {
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ((Task)task2.get()).doFirst((Closure)new _isRequiredByCore_closure11(this, this, task2));
        }
    }

    public void isRequiredBy(Task task) {
        this.isRequiredByCore(task, false);
    }

    public void isRequiredBy(TaskProvider<? extends Task> taskProvider) {
        public final class _isRequiredBy_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isRequiredBy_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"isRequiredByCore", (Object)new Object[]{it, true});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isRequiredBy_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        taskProvider.configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _isRequiredBy_closure12(this, this)), Action.class));
    }

    public Map<String, ServiceInfo> getServicesInfos() {
        return ((ComposeUp)((Object)this.upTask.get())).getServicesInfos();
    }

    public void exposeAsEnvironment(ProcessForkOptions task) {
        Reference task2 = new Reference((Object)task);
        public final class _exposeAsEnvironment_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _exposeAsEnvironment_closure13(Object _outerInstance, Object _thisObject, Reference task) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.task = reference = task;
            }

            public Object doCall(Object serviceInfo) {
                Reference serviceInfo2 = new Reference(serviceInfo);
                public final class _closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference serviceInfo;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure20(Object _outerInstance, Object _thisObject, Reference task, Reference serviceInfo) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.task = reference2 = task;
                        this.serviceInfo = reference = serviceInfo;
                    }

                    public Object doCall(Object instanceName, Object si) {
                        if (((String)instanceName).endsWith("_1")) {
                            DefaultGroovyMethods.leftShift((Map)((ProcessForkOptions)this.task.get()).getEnvironment(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createEnvironmentVariables", (Object)new Object[]{((ServiceInfo)this.serviceInfo.get()).getName().toUpperCase(), si}), Map.class)));
                        }
                        return DefaultGroovyMethods.leftShift((Map)((ProcessForkOptions)this.task.get()).getEnvironment(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createEnvironmentVariables", (Object)new Object[]{((String)instanceName).toUpperCase(), si}), Map.class)));
                    }

                    public Object call(Object instanceName, Object si) {
                        return this.doCall(instanceName, si);
                    }

                    @Generated
                    public ProcessForkOptions getTask() {
                        return (ProcessForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), ProcessForkOptions.class);
                    }

                    @Generated
                    public Object getServiceInfo() {
                        return this.serviceInfo.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each(((ServiceInfo)serviceInfo2.get()).getContainerInfos(), (Closure)new _closure20((Object)this, this.getThisObject(), this.task, serviceInfo2));
            }

            @Generated
            public ProcessForkOptions getTask() {
                return (ProcessForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), ProcessForkOptions.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exposeAsEnvironment_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getServicesInfos().values(), (Closure)new _exposeAsEnvironment_closure13(this, this, task2));
    }

    public void exposeAsSystemProperties(JavaForkOptions task) {
        Reference task2 = new Reference((Object)task);
        public final class _exposeAsSystemProperties_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _exposeAsSystemProperties_closure14(Object _outerInstance, Object _thisObject, Reference task) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.task = reference = task;
            }

            public Object doCall(Object serviceInfo) {
                Reference serviceInfo2 = new Reference(serviceInfo);
                public final class _closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference serviceInfo;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure21(Object _outerInstance, Object _thisObject, Reference task, Reference serviceInfo) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.task = reference2 = task;
                        this.serviceInfo = reference = serviceInfo;
                    }

                    public Object doCall(Object instanceName, Object si) {
                        if (((String)instanceName).endsWith("_1")) {
                            DefaultGroovyMethods.leftShift((Map)((JavaForkOptions)this.task.get()).getSystemProperties(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createSystemProperties", (Object)new Object[]{((ServiceInfo)this.serviceInfo.get()).getName(), si}), Map.class)));
                        }
                        return DefaultGroovyMethods.leftShift((Map)((JavaForkOptions)this.task.get()).getSystemProperties(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createSystemProperties", (Object)new Object[]{instanceName, si}), Map.class)));
                    }

                    public Object call(Object instanceName, Object si) {
                        return this.doCall(instanceName, si);
                    }

                    @Generated
                    public JavaForkOptions getTask() {
                        return (JavaForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), JavaForkOptions.class);
                    }

                    @Generated
                    public Object getServiceInfo() {
                        return this.serviceInfo.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each(((ServiceInfo)serviceInfo2.get()).getContainerInfos(), (Closure)new _closure21((Object)this, this.getThisObject(), this.task, serviceInfo2));
            }

            @Generated
            public JavaForkOptions getTask() {
                return (JavaForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), JavaForkOptions.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exposeAsSystemProperties_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getServicesInfos().values(), (Closure)new _exposeAsSystemProperties_closure14(this, this, task2));
    }

    protected Map<String, Object> createEnvironmentVariables(String variableName, ContainerInfo ci) {
        Reference variableName2 = new Reference((Object)variableName);
        Reference environmentVariables = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        ((LinkedHashMap)environmentVariables.get()).put(new GStringImpl(new Object[]{(String)variableName2.get()}, new String[]{"", "_HOST"}).toString(), ci.getHost());
        ((LinkedHashMap)environmentVariables.get()).put(new GStringImpl(new Object[]{(String)variableName2.get()}, new String[]{"", "_CONTAINER_HOSTNAME"}).toString(), ci.getContainerHostname());
        public final class _createEnvironmentVariables_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference environmentVariables;
            private /* synthetic */ Reference variableName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createEnvironmentVariables_closure15(Object _outerInstance, Object _thisObject, Reference environmentVariables, Reference variableName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.environmentVariables = reference2 = environmentVariables;
                this.variableName = reference = variableName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.environmentVariables.get()).put(new GStringImpl(new Object[]{this.variableName.get(), ((Map.Entry)it).getKey()}, new String[]{"", "_TCP_", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getEnvironmentVariables() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.environmentVariables.get(), Map.class);
            }

            @Generated
            public String getVariableName() {
                return ShortTypeHandling.castToString((Object)this.variableName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createEnvironmentVariables_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getTcpPorts(), (Closure)new _createEnvironmentVariables_closure15(this, this, environmentVariables, variableName2));
        public final class _createEnvironmentVariables_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference environmentVariables;
            private /* synthetic */ Reference variableName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createEnvironmentVariables_closure16(Object _outerInstance, Object _thisObject, Reference environmentVariables, Reference variableName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.environmentVariables = reference2 = environmentVariables;
                this.variableName = reference = variableName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.environmentVariables.get()).put(new GStringImpl(new Object[]{this.variableName.get(), ((Map.Entry)it).getKey()}, new String[]{"", "_UDP_", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getEnvironmentVariables() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.environmentVariables.get(), Map.class);
            }

            @Generated
            public String getVariableName() {
                return ShortTypeHandling.castToString((Object)this.variableName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createEnvironmentVariables_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getUdpPorts(), (Closure)new _createEnvironmentVariables_closure16(this, this, environmentVariables, variableName2));
        return (LinkedHashMap)environmentVariables.get();
    }

    protected Map<String, Object> createSystemProperties(String variableName, ContainerInfo ci) {
        Reference variableName2 = new Reference((Object)variableName);
        Reference systemProperties = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        ((LinkedHashMap)systemProperties.get()).put(new GStringImpl(new Object[]{(String)variableName2.get()}, new String[]{"", ".host"}).toString(), ci.getHost());
        ((LinkedHashMap)systemProperties.get()).put(new GStringImpl(new Object[]{(String)variableName2.get()}, new String[]{"", ".containerHostname"}).toString(), ci.getContainerHostname());
        public final class _createSystemProperties_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference systemProperties;
            private /* synthetic */ Reference variableName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createSystemProperties_closure17(Object _outerInstance, Object _thisObject, Reference systemProperties, Reference variableName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.systemProperties = reference2 = systemProperties;
                this.variableName = reference = variableName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.systemProperties.get()).put(new GStringImpl(new Object[]{this.variableName.get(), ((Map.Entry)it).getKey()}, new String[]{"", ".tcp.", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getSystemProperties() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.systemProperties.get(), Map.class);
            }

            @Generated
            public String getVariableName() {
                return ShortTypeHandling.castToString((Object)this.variableName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createSystemProperties_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getTcpPorts(), (Closure)new _createSystemProperties_closure17(this, this, systemProperties, variableName2));
        public final class _createSystemProperties_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference systemProperties;
            private /* synthetic */ Reference variableName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createSystemProperties_closure18(Object _outerInstance, Object _thisObject, Reference systemProperties, Reference variableName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.systemProperties = reference2 = systemProperties;
                this.variableName = reference = variableName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.systemProperties.get()).put(new GStringImpl(new Object[]{this.variableName.get(), ((Map.Entry)it).getKey()}, new String[]{"", ".udp.", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getSystemProperties() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.systemProperties.get(), Map.class);
            }

            @Generated
            public String getVariableName() {
                return ShortTypeHandling.castToString((Object)this.variableName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createSystemProperties_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getUdpPorts(), (Closure)new _createSystemProperties_closure18(this, this, systemProperties, variableName2));
        return (LinkedHashMap)systemProperties.get();
    }

    public void setCaptureContainersOutputToFile(CharSequence path) {
        File file;
        this.captureContainersOutputToFile = file = this.project.file((Object)path);
    }

    public void setCaptureContainersOutputToFile(File file) {
        File file2;
        this.captureContainersOutputToFile = file2 = file;
    }

    public void setCaptureContainersOutputToFiles(CharSequence path) {
        File file;
        this.captureContainersOutputToFiles = file = this.project.file((Object)path);
    }

    public void setCaptureContainersOutputToFiles(File file) {
        File file2;
        this.captureContainersOutputToFiles = file2 = file;
    }

    public void setComposeLogToFile(CharSequence path) {
        File file;
        this.composeLogToFile = file = this.project.file((Object)path);
    }

    public void setComposeLogToFile(File file) {
        File file2;
        this.composeLogToFile = file2 = file;
    }

    public boolean removeOrphans() {
        return ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.composeExecutor.getVersion(), (Object)VersionNumber.parse((String)"1.7.0")) && this.removeOrphans;
    }

    public boolean scale() {
        VersionNumber v = this.composeExecutor.getVersion();
        if (ScriptBytecodeAdapter.compareLessThan((Object)v, (Object)VersionNumber.parse((String)"1.13.0")) && DefaultTypeTransformation.booleanUnbox(this.scale)) {
            throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{v}, new String[]{"docker-compose version ", " doesn't support --scale option"})));
        }
        return DefaultTypeTransformation.booleanUnbox(this.scale);
    }

    public static /* synthetic */ TaskProvider<ComposeUp> pfaccess$0(ComposeSettings $that) {
        return $that.upTask;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ComposeSettings.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final TaskProvider<ComposeUp> getUpTask() {
        return this.upTask;
    }

    @Generated
    public final TaskProvider<ComposeDown> getDownTask() {
        return this.downTask;
    }

    @Generated
    public final TaskProvider<ComposeDownForced> getDownForcedTask() {
        return this.downForcedTask;
    }

    @Generated
    public final TaskProvider<ComposeBuild> getBuildTask() {
        return this.buildTask;
    }

    @Generated
    public final TaskProvider<ComposePull> getPullTask() {
        return this.pullTask;
    }

    @Generated
    public final TaskProvider<ComposeLogs> getLogsTask() {
        return this.logsTask;
    }

    @Generated
    public final TaskProvider<ComposePush> getPushTask() {
        return this.pushTask;
    }

    @Generated
    public final Project getProject() {
        return this.project;
    }

    @Generated
    public final DockerExecutor getDockerExecutor() {
        return this.dockerExecutor;
    }

    @Generated
    public final ComposeExecutor getComposeExecutor() {
        return this.composeExecutor;
    }

    @Generated
    public final ServiceInfoCache getServiceInfoCache() {
        return this.serviceInfoCache;
    }

    @Generated
    public boolean getBuildBeforeUp() {
        return this.buildBeforeUp;
    }

    @Generated
    public boolean isBuildBeforeUp() {
        return this.buildBeforeUp;
    }

    @Generated
    public void setBuildBeforeUp(boolean bl) {
        this.buildBeforeUp = bl;
    }

    @Generated
    public boolean getBuildBeforePull() {
        return this.buildBeforePull;
    }

    @Generated
    public boolean isBuildBeforePull() {
        return this.buildBeforePull;
    }

    @Generated
    public void setBuildBeforePull(boolean bl) {
        this.buildBeforePull = bl;
    }

    @Generated
    public boolean getWaitForTcpPorts() {
        return this.waitForTcpPorts;
    }

    @Generated
    public boolean isWaitForTcpPorts() {
        return this.waitForTcpPorts;
    }

    @Generated
    public void setWaitForTcpPorts(boolean bl) {
        this.waitForTcpPorts = bl;
    }

    @Generated
    public List<Integer> getTcpPortsToIgnoreWhenWaiting() {
        return this.tcpPortsToIgnoreWhenWaiting;
    }

    @Generated
    public void setTcpPortsToIgnoreWhenWaiting(List<Integer> list) {
        this.tcpPortsToIgnoreWhenWaiting = list;
    }

    @Generated
    public Duration getWaitAfterTcpProbeFailure() {
        return this.waitAfterTcpProbeFailure;
    }

    @Generated
    public void setWaitAfterTcpProbeFailure(Duration duration) {
        this.waitAfterTcpProbeFailure = duration;
    }

    @Generated
    public Duration getWaitForTcpPortsTimeout() {
        return this.waitForTcpPortsTimeout;
    }

    @Generated
    public void setWaitForTcpPortsTimeout(Duration duration) {
        this.waitForTcpPortsTimeout = duration;
    }

    @Generated
    public Duration getWaitForTcpPortsDisconnectionProbeTimeout() {
        return this.waitForTcpPortsDisconnectionProbeTimeout;
    }

    @Generated
    public void setWaitForTcpPortsDisconnectionProbeTimeout(Duration duration) {
        this.waitForTcpPortsDisconnectionProbeTimeout = duration;
    }

    @Generated
    public Duration getWaitAfterHealthyStateProbeFailure() {
        return this.waitAfterHealthyStateProbeFailure;
    }

    @Generated
    public void setWaitAfterHealthyStateProbeFailure(Duration duration) {
        this.waitAfterHealthyStateProbeFailure = duration;
    }

    @Generated
    public Duration getWaitForHealthyStateTimeout() {
        return this.waitForHealthyStateTimeout;
    }

    @Generated
    public void setWaitForHealthyStateTimeout(Duration duration) {
        this.waitForHealthyStateTimeout = duration;
    }

    @Generated
    public boolean getCheckContainersRunning() {
        return this.checkContainersRunning;
    }

    @Generated
    public boolean isCheckContainersRunning() {
        return this.checkContainersRunning;
    }

    @Generated
    public void setCheckContainersRunning(boolean bl) {
        this.checkContainersRunning = bl;
    }

    @Generated
    public List<String> getUseComposeFiles() {
        return this.useComposeFiles;
    }

    @Generated
    public void setUseComposeFiles(List<String> list) {
        this.useComposeFiles = list;
    }

    @Generated
    public boolean getCaptureContainersOutput() {
        return this.captureContainersOutput;
    }

    @Generated
    public boolean isCaptureContainersOutput() {
        return this.captureContainersOutput;
    }

    @Generated
    public void setCaptureContainersOutput(boolean bl) {
        this.captureContainersOutput = bl;
    }

    @Generated
    public File getCaptureContainersOutputToFile() {
        return this.captureContainersOutputToFile;
    }

    @Generated
    public File getCaptureContainersOutputToFiles() {
        return this.captureContainersOutputToFiles;
    }

    @Generated
    public File getComposeLogToFile() {
        return this.composeLogToFile;
    }

    @Generated
    public File getContainerLogToDir() {
        return this.containerLogToDir;
    }

    @Generated
    public void setContainerLogToDir(File file) {
        this.containerLogToDir = file;
    }

    @Generated
    public List<String> getStartedServices() {
        return this.startedServices;
    }

    @Generated
    public void setStartedServices(List<String> list) {
        this.startedServices = list;
    }

    @Generated
    public Map<String, Integer> getScale() {
        return this.scale;
    }

    @Generated
    public void setScale(Map<String, Integer> map) {
        this.scale = map;
    }

    @Generated
    public boolean getRemoveOrphans() {
        return this.removeOrphans;
    }

    @Generated
    public boolean isRemoveOrphans() {
        return this.removeOrphans;
    }

    @Generated
    public void setRemoveOrphans(boolean bl) {
        this.removeOrphans = bl;
    }

    @Generated
    public boolean getForceRecreate() {
        return this.forceRecreate;
    }

    @Generated
    public boolean isForceRecreate() {
        return this.forceRecreate;
    }

    @Generated
    public void setForceRecreate(boolean bl) {
        this.forceRecreate = bl;
    }

    @Generated
    public boolean getNoRecreate() {
        return this.noRecreate;
    }

    @Generated
    public boolean isNoRecreate() {
        return this.noRecreate;
    }

    @Generated
    public void setNoRecreate(boolean bl) {
        this.noRecreate = bl;
    }

    @Generated
    public List<String> getBuildAdditionalArgs() {
        return this.buildAdditionalArgs;
    }

    @Generated
    public void setBuildAdditionalArgs(List<String> list) {
        this.buildAdditionalArgs = list;
    }

    @Generated
    public List<String> getPullAdditionalArgs() {
        return this.pullAdditionalArgs;
    }

    @Generated
    public void setPullAdditionalArgs(List<String> list) {
        this.pullAdditionalArgs = list;
    }

    @Generated
    public List<String> getUpAdditionalArgs() {
        return this.upAdditionalArgs;
    }

    @Generated
    public void setUpAdditionalArgs(List<String> list) {
        this.upAdditionalArgs = list;
    }

    @Generated
    public List<String> getDownAdditionalArgs() {
        return this.downAdditionalArgs;
    }

    @Generated
    public void setDownAdditionalArgs(List<String> list) {
        this.downAdditionalArgs = list;
    }

    @Generated
    public List<String> getComposeAdditionalArgs() {
        return this.composeAdditionalArgs;
    }

    @Generated
    public void setComposeAdditionalArgs(List<String> list) {
        this.composeAdditionalArgs = list;
    }

    @Generated
    public String getProjectNamePrefix() {
        return this.projectNamePrefix;
    }

    @Generated
    public void setProjectNamePrefix(String string) {
        this.projectNamePrefix = string;
    }

    @Generated
    public String getNestedName() {
        return this.nestedName;
    }

    @Generated
    public void setNestedName(String string) {
        this.nestedName = string;
    }

    @Generated
    public boolean getStopContainers() {
        return this.stopContainers;
    }

    @Generated
    public boolean isStopContainers() {
        return this.stopContainers;
    }

    @Generated
    public void setStopContainers(boolean bl) {
        this.stopContainers = bl;
    }

    @Generated
    public boolean getRemoveContainers() {
        return this.removeContainers;
    }

    @Generated
    public boolean isRemoveContainers() {
        return this.removeContainers;
    }

    @Generated
    public void setRemoveContainers(boolean bl) {
        this.removeContainers = bl;
    }

    @Generated
    public boolean getRetainContainersOnStartupFailure() {
        return this.retainContainersOnStartupFailure;
    }

    @Generated
    public boolean isRetainContainersOnStartupFailure() {
        return this.retainContainersOnStartupFailure;
    }

    @Generated
    public void setRetainContainersOnStartupFailure(boolean bl) {
        this.retainContainersOnStartupFailure = bl;
    }

    @Generated
    public RemoveImages getRemoveImages() {
        return this.removeImages;
    }

    @Generated
    public void setRemoveImages(RemoveImages removeImages) {
        this.removeImages = removeImages;
    }

    @Generated
    public boolean getRemoveVolumes() {
        return this.removeVolumes;
    }

    @Generated
    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    @Generated
    public void setRemoveVolumes(boolean bl) {
        this.removeVolumes = bl;
    }

    @Generated
    public boolean getIncludeDependencies() {
        return this.includeDependencies;
    }

    @Generated
    public boolean isIncludeDependencies() {
        return this.includeDependencies;
    }

    @Generated
    public void setIncludeDependencies(boolean bl) {
        this.includeDependencies = bl;
    }

    @Generated
    public boolean getIgnorePullFailure() {
        return this.ignorePullFailure;
    }

    @Generated
    public boolean isIgnorePullFailure() {
        return this.ignorePullFailure;
    }

    @Generated
    public void setIgnorePullFailure(boolean bl) {
        this.ignorePullFailure = bl;
    }

    @Generated
    public boolean getIgnorePushFailure() {
        return this.ignorePushFailure;
    }

    @Generated
    public boolean isIgnorePushFailure() {
        return this.ignorePushFailure;
    }

    @Generated
    public void setIgnorePushFailure(boolean bl) {
        this.ignorePushFailure = bl;
    }

    @Generated
    public List<String> getPushServices() {
        return this.pushServices;
    }

    @Generated
    public void setPushServices(List<String> list) {
        this.pushServices = list;
    }

    @Generated
    public String getExecutable() {
        return this.executable;
    }

    @Generated
    public void setExecutable(String string) {
        this.executable = string;
    }

    @Generated
    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    @Generated
    public void setEnvironment(Map<String, Object> map) {
        this.environment = map;
    }

    @Generated
    public String getDockerExecutable() {
        return this.dockerExecutable;
    }

    @Generated
    public void setDockerExecutable(String string) {
        this.dockerExecutable = string;
    }

    @Generated
    public String getDockerComposeWorkingDirectory() {
        return this.dockerComposeWorkingDirectory;
    }

    @Generated
    public void setDockerComposeWorkingDirectory(String string) {
        this.dockerComposeWorkingDirectory = string;
    }

    @Generated
    public Duration getDockerComposeStopTimeout() {
        return this.dockerComposeStopTimeout;
    }

    @Generated
    public void setDockerComposeStopTimeout(Duration duration) {
        this.dockerComposeStopTimeout = duration;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeUp)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeBuild)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure3
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure3(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposePull)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure4
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure4(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ScriptBytecodeAdapter.setProperty((Object)composeSettings, null, (Object)it, (String)"settings");
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure5
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure5(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeDownForced)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure5.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure6
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure6(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeLogs)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure6.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure7
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure7(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposePush)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure7.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

