/*
 * Decompiled with CFR 0.152.
 */
package com.avast.gradle.dockercompose.util;

import java.util.Objects;
import javax.annotation.Nullable;

public class VersionNumber
implements Comparable<VersionNumber> {
    public static final VersionNumber UNKNOWN = new VersionNumber(0, 0, 0);
    private final int major;
    private final int minor;
    private final int micro;

    private VersionNumber(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.micro) {
            return this.micro - other.micro;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.micro);
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.micro);
    }

    public static VersionNumber parse(String versionString) {
        if (versionString == null || versionString.length() == 0) {
            return UNKNOWN;
        }
        Scanner scanner = new Scanner(versionString);
        int major = 0;
        int minor = 0;
        int micro = 0;
        if (!scanner.hasDigit()) {
            return UNKNOWN;
        }
        major = scanner.scanDigit();
        if (scanner.isSeparatorAndDigit()) {
            scanner.skipSeparator();
            minor = scanner.scanDigit();
            if (scanner.isSeparatorAndDigit()) {
                scanner.skipSeparator();
                micro = scanner.scanDigit();
            }
        }
        if (scanner.isEnd() || scanner.hasSpecifierSeparator()) {
            return new VersionNumber(major, minor, micro);
        }
        return UNKNOWN;
    }

    private static class Scanner {
        int pos;
        final String str;

        private Scanner(String string) {
            this.str = string;
        }

        boolean hasDigit() {
            return this.pos < this.str.length() && Character.isDigit(this.str.charAt(this.pos));
        }

        boolean hasSpecifierSeparator() {
            return this.pos < this.str.length() && (this.str.charAt(this.pos) == '-' || this.str.charAt(this.pos) == '+');
        }

        boolean isSeparatorAndDigit() {
            return this.pos < this.str.length() - 1 && this.isSeparator() && Character.isDigit(this.str.charAt(this.pos + 1));
        }

        private boolean isSeparator() {
            return this.str.charAt(this.pos) == '.';
        }

        int scanDigit() {
            int start = this.pos;
            while (this.hasDigit()) {
                ++this.pos;
            }
            return Integer.parseInt(this.str.substring(start, this.pos));
        }

        public boolean isEnd() {
            return this.pos == this.str.length();
        }

        public void skipSeparator() {
            ++this.pos;
        }
    }
}

