/*
 * Decompiled with CFR 0.152.
 */
package com.avast.metrics;

import com.avast.metrics.api.Timer;
import com.avast.metrics.api.TimerPair;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class TimerPairImpl
implements TimerPair {
    private final Timer successTimer;
    private final Timer failureTimer;

    public TimerPairImpl(Timer timer, Timer timer2) {
        this.successTimer = timer;
        this.failureTimer = timer2;
    }

    @Override
    public TimerPair.TimeContext start() {
        return new Context(this.successTimer.start(), this.failureTimer.start());
    }

    @Override
    public void update(Duration duration) {
        this.successTimer.update(duration);
    }

    @Override
    public void updateFailure(Duration duration) {
        this.failureTimer.update(duration);
    }

    @Override
    public <T> T time(Callable<T> callable) throws Exception {
        Timer.TimeContext timeContext = this.successTimer.start();
        Timer.TimeContext timeContext2 = this.failureTimer.start();
        try {
            T t = callable.call();
            timeContext.stop();
            return t;
        }
        catch (Exception exception) {
            timeContext2.stop();
            throw exception;
        }
    }

    @Override
    public <T> CompletableFuture<T> timeAsync(Callable<CompletableFuture<T>> callable, Executor executor) throws Exception {
        Timer.TimeContext timeContext = this.successTimer.start();
        Timer.TimeContext timeContext2 = this.failureTimer.start();
        try {
            CompletableFuture completableFuture = new CompletableFuture();
            CompletableFuture<T> completableFuture2 = callable.call();
            completableFuture2.handleAsync((object, throwable) -> {
                if (throwable == null) {
                    timeContext.stop();
                    completableFuture.complete(object);
                } else {
                    timeContext2.stop();
                    completableFuture.completeExceptionally((Throwable)throwable);
                }
                return null;
            }, executor);
            return completableFuture;
        }
        catch (Exception exception) {
            timeContext2.stop();
            throw exception;
        }
    }

    private static class Context
    implements TimerPair.TimeContext {
        private final Timer.TimeContext successContext;
        private final Timer.TimeContext failureContext;

        Context(Timer.TimeContext timeContext, Timer.TimeContext timeContext2) {
            this.successContext = timeContext;
            this.failureContext = timeContext2;
        }

        @Override
        public void stop() {
            this.successContext.stop();
        }

        @Override
        public void stopFailure() {
            this.failureContext.stop();
        }
    }
}

