/*
 * Decompiled with CFR 0.152.
 */
package com.avast.server.toolkit.ssl;

import cats.FlatMap;
import cats.Functor;
import cats.effect.Bracket;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.syntax.package;
import com.avast.server.toolkit.ssl.KeyStoreType$;
import com.avast.server.toolkit.ssl.Protocol$;
import com.avast.server.toolkit.ssl.SslContextConfig;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class SslContextModule$ {
    public static SslContextModule$ MODULE$;

    static {
        new SslContextModule$();
    }

    public <F> F make(SslContextConfig config, Sync<F> evidence$1) {
        Sync F = Sync$.MODULE$.apply(evidence$1);
        return (F)package.flatMap$.MODULE$.toFlatMapOps(F.delay((Function0 & Serializable & scala.Serializable)() -> config.loadSystemKeyManagers() ? MODULE$.getKeyManagers(null, null) : List$.MODULE$.empty()), evidence$1).flatMap((Function1 & Serializable & scala.Serializable)systemKeyManagers -> package.flatMap$.MODULE$.toFlatMapOps(F.delay((Function0 & Serializable & scala.Serializable)() -> config.loadSystemTrustManagers() ? MODULE$.getTrustManagers(null) : List$.MODULE$.empty()), (FlatMap)evidence$1).flatMap((Function1 & Serializable & scala.Serializable)systemTrustManagers -> package.flatMap$.MODULE$.toFlatMapOps(package.functor$.MODULE$.toFunctorOps(config.keystore().map((Function1 & Serializable & scala.Serializable)keystore -> Resource$.MODULE$.fromAutoCloseable(F.delay((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(keystore.path(), new OpenOption[0])), evidence$1).use((Function1 & Serializable & scala.Serializable)keystoreInputStream -> {
            KeyStore ks = KeyStore.getInstance(package.show$.MODULE$.toShow((Object)keystore.keystoreType(), KeyStoreType$.MODULE$.show()).show());
            ks.load((InputStream)keystoreInputStream, keystore.password().toCharArray());
            return F.delay((Function0 & Serializable & scala.Serializable)() -> (List)MODULE$.getKeyManagers(ks, (String)keystore.keyPassword().orNull(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)systemKeyManagers, List$.MODULE$.canBuildFrom()));
        }, (Bracket)evidence$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> F.delay((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty())), (Functor)evidence$1).map((Function1 & Serializable & scala.Serializable)x$1 -> (KeyManager[])x$1.toArray(ClassTag$.MODULE$.apply(KeyManager.class))), (FlatMap)evidence$1).flatMap((Function1 & Serializable & scala.Serializable)keyManagers -> package.functor$.MODULE$.toFunctorOps(package.functor$.MODULE$.toFunctorOps(config.truststore().map((Function1 & Serializable & scala.Serializable)truststore -> Resource$.MODULE$.fromAutoCloseable(F.delay((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(truststore.path(), new OpenOption[0])), evidence$1).use((Function1 & Serializable & scala.Serializable)truststoreInpuStream -> {
            KeyStore ks = KeyStore.getInstance(package.show$.MODULE$.toShow((Object)truststore.keystoreType(), KeyStoreType$.MODULE$.show()).show());
            ks.load((InputStream)truststoreInpuStream, truststore.password().toCharArray());
            return F.delay((Function0 & Serializable & scala.Serializable)() -> (List)MODULE$.getTrustManagers(ks).$plus$plus((GenTraversableOnce)systemTrustManagers, List$.MODULE$.canBuildFrom()));
        }, (Bracket)evidence$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> F.delay((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty())), (Functor)evidence$1).map((Function1 & Serializable & scala.Serializable)x$2 -> (TrustManager[])x$2.toArray(ClassTag$.MODULE$.apply(TrustManager.class))), (Functor)evidence$1).map((Function1 & Serializable & scala.Serializable)trustManagers -> {
            void var3_3;
            SSLContext context = SSLContext.getInstance(package.show$.MODULE$.toShow((Object)config.protocol(), Protocol$.MODULE$.show()).show());
            context.init((KeyManager[])keyManagers, (TrustManager[])trustManagers, null);
            return var3_3;
        }))));
    }

    private List<KeyManager> getKeyManagers(KeyStore keystore, String keyPassword) {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(keystore, (char[])Option$.MODULE$.apply((Object)keyPassword).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toCharArray()).orNull(Predef$.MODULE$.$conforms()));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])factory.getKeyManagers())).toList();
    }

    private List<TrustManager> getTrustManagers(KeyStore keystore) {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])factory.getTrustManagers())).toList();
    }

    private SslContextModule$() {
        MODULE$ = this;
    }
}

