/*
 * Decompiled with CFR 0.152.
 */
package com.avast.sst.jvm.execution;

import com.avast.sst.jvm.execution.ConfigurableThreadFactory$Config$;
import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ConfigurableThreadFactory
implements ThreadFactory,
ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final Config config;
    private final AtomicLong counter;

    public ConfigurableThreadFactory(Config config) {
        this.config = config;
        this.counter = new AtomicLong(0L);
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.configure(new Thread(r));
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        return this.configure(ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool));
    }

    private <A extends Thread> A configure(A thread) {
        this.config.nameFormat().map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(_$1), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.counter.getAndIncrement())}))).foreach((Function1)(JProcedure1 & Serializable)x$0 -> thread.setName((String)x$0));
        thread.setDaemon(this.config.daemon());
        thread.setPriority(this.config.priority());
        thread.setUncaughtExceptionHandler(this.config.uncaughtExceptionHandler());
        return thread;
    }

    public static final class Config
    implements Product,
    Serializable {
        private final Option nameFormat;
        private final boolean daemon;
        private final int priority;
        private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        public static Config apply(Option<String> option, boolean bl, int n, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return ConfigurableThreadFactory$Config$.MODULE$.apply(option, bl, n, uncaughtExceptionHandler);
        }

        public static Config fromProduct(Product product) {
            return ConfigurableThreadFactory$Config$.MODULE$.fromProduct(product);
        }

        public static Config unapply(Config config) {
            return ConfigurableThreadFactory$Config$.MODULE$.unapply(config);
        }

        public static Option<String> $lessinit$greater$default$1() {
            return ConfigurableThreadFactory$Config$.MODULE$.$lessinit$greater$default$1();
        }

        public static boolean $lessinit$greater$default$2() {
            return ConfigurableThreadFactory$Config$.MODULE$.$lessinit$greater$default$2();
        }

        public static int $lessinit$greater$default$3() {
            return ConfigurableThreadFactory$Config$.MODULE$.$lessinit$greater$default$3();
        }

        public static Thread.UncaughtExceptionHandler $lessinit$greater$default$4() {
            return ConfigurableThreadFactory$Config$.MODULE$.$lessinit$greater$default$4();
        }

        public Config(Option<String> nameFormat, boolean daemon, int priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.nameFormat = nameFormat;
            this.daemon = daemon;
            this.priority = priority;
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nameFormat()));
            n = Statics.mix((int)n, (int)(this.daemon() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.priority());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.uncaughtExceptionHandler()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Config)) return false;
            Config config = (Config)object;
            if (this.daemon() != config.daemon()) return false;
            if (this.priority() != config.priority()) return false;
            Option<String> option = this.nameFormat();
            Option<String> option2 = config.nameFormat();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.uncaughtExceptionHandler();
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = config.uncaughtExceptionHandler();
            if (uncaughtExceptionHandler == null) {
                if (uncaughtExceptionHandler2 == null) return true;
                return false;
            } else {
                if (!uncaughtExceptionHandler.equals(uncaughtExceptionHandler2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Config;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Config";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "nameFormat";
                    break;
                }
                case 1: {
                    string = "daemon";
                    break;
                }
                case 2: {
                    string = "priority";
                    break;
                }
                case 3: {
                    string = "uncaughtExceptionHandler";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Option<String> nameFormat() {
            return this.nameFormat;
        }

        public boolean daemon() {
            return this.daemon;
        }

        public int priority() {
            return this.priority;
        }

        public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
            return this.uncaughtExceptionHandler;
        }

        public Config copy(Option<String> nameFormat, boolean daemon, int priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return new Config(nameFormat, daemon, priority, uncaughtExceptionHandler);
        }

        public Option<String> copy$default$1() {
            return this.nameFormat();
        }

        public boolean copy$default$2() {
            return this.daemon();
        }

        public int copy$default$3() {
            return this.priority();
        }

        public Thread.UncaughtExceptionHandler copy$default$4() {
            return this.uncaughtExceptionHandler();
        }

        public Option<String> _1() {
            return this.nameFormat();
        }

        public boolean _2() {
            return this.daemon();
        }

        public int _3() {
            return this.priority();
        }

        public Thread.UncaughtExceptionHandler _4() {
            return this.uncaughtExceptionHandler();
        }
    }
}

