/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.cucumber.adapter;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.MediaEntityBuilder;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.cucumber.adapter.TestSourcesModel;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.Feature;
import com.aventstack.extentreports.gherkin.model.Scenario;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.service.ExtentService;
import cucumber.api.HookTestStep;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.runtime.CucumberException;
import cucumber.runtime.io.URLOutputStream;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Node;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.pickles.Argument;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ExtentCucumberAdapter
implements ConcurrentEventListener {
    private static final String SCREENSHOT_DIR_PROPERTY = "screenshot.dir";
    private static Map<String, ExtentTest> featureMap = new ConcurrentHashMap<String, ExtentTest>();
    private static ThreadLocal<ExtentTest> featureTestThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static Map<String, ExtentTest> scenarioOutlineMap = new ConcurrentHashMap<String, ExtentTest>();
    private static ThreadLocal<ExtentTest> scenarioOutlineThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static ThreadLocal<ExtentTest> scenarioThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static ThreadLocal<Boolean> isHookThreadLocal = new InheritableThreadLocal<Boolean>();
    private static ThreadLocal<ExtentTest> stepTestThreadLocal = new InheritableThreadLocal<ExtentTest>();
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("image/svg+xml", "svg");
            this.put("video/ogg", "ogg");
        }
    };
    private static final AtomicInteger EMBEDDED_INT = new AtomicInteger(0);
    private final TestSourcesModel testSources = new TestSourcesModel();
    private ThreadLocal<String> currentFeatureFile = new ThreadLocal();
    private ThreadLocal<ScenarioOutline> currentScenarioOutline = new InheritableThreadLocal<ScenarioOutline>();
    private ThreadLocal<Examples> currentExamples = new InheritableThreadLocal<Examples>();
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            ExtentCucumberAdapter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            ExtentCucumberAdapter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            ExtentCucumberAdapter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            ExtentCucumberAdapter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<EmbedEvent> embedEventhandler = new EventHandler<EmbedEvent>(){

        public void receive(EmbedEvent event) {
            ExtentCucumberAdapter.this.handleEmbed(event);
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        public void receive(WriteEvent event) {
            ExtentCucumberAdapter.this.handleWrite(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            ExtentCucumberAdapter.this.finishReport();
        }
    };

    public ExtentCucumberAdapter(String arg) {
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private synchronized void handleTestCaseStarted(TestCaseStarted event) {
        this.handleStartOfFeature(event.testCase);
        this.handleScenarioOutline(event.testCase);
        this.createTestCase(event.testCase);
        if (this.testSources.hasBackground(this.currentFeatureFile.get(), event.testCase.getLine())) {
            // empty if block
        }
    }

    private synchronized void handleTestStepStarted(TestStepStarted event) {
        isHookThreadLocal.set(false);
        if (event.testStep instanceof HookTestStep) {
            ExtentTest t = scenarioThreadLocal.get().createNode(Asterisk.class, event.testStep.getCodeLocation());
            stepTestThreadLocal.set(t);
            isHookThreadLocal.set(true);
        }
        if (event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
            this.createTestStep(testStep);
        }
    }

    private synchronized void handleTestStepFinished(TestStepFinished event) {
        this.updateResult(event.result);
    }

    private synchronized void updateResult(Result result) {
        switch (result.getStatus().lowerCaseName()) {
            case "failed": {
                stepTestThreadLocal.get().fail(result.getError());
                break;
            }
            case "skipped": 
            case "pending": {
                Boolean currentEndingEventSkipped = stepTestThreadLocal.get().getModel().getLogContext() != null && !stepTestThreadLocal.get().getModel().getLogContext().isEmpty() ? ((Log)stepTestThreadLocal.get().getModel().getLogContext().getLast()).getStatus() == Status.SKIP : false;
                if (result.getError() != null) {
                    stepTestThreadLocal.get().skip(result.getError());
                    break;
                }
                if (currentEndingEventSkipped.booleanValue()) break;
                String details = result.getErrorMessage() == null ? "Step skipped" : result.getErrorMessage();
                stepTestThreadLocal.get().skip(details);
                break;
            }
            case "passed": {
                if (stepTestThreadLocal.get() != null && stepTestThreadLocal.get().getModel().getLogContext().isEmpty()) {
                    stepTestThreadLocal.get().pass("");
                }
                if (!isHookThreadLocal.get().booleanValue() || stepTestThreadLocal.get().getModel().hasLog() || ((Log)stepTestThreadLocal.get().getModel().getLogContext().getFirst()).hasScreenCapture()) break;
                ExtentService.getInstance().removeTest(stepTestThreadLocal.get());
                break;
            }
        }
    }

    private synchronized void handleEmbed(EmbedEvent event) {
        String mimeType = event.mimeType;
        String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
        if (extension != null) {
            StringBuilder fileName = new StringBuilder("embedded").append(EMBEDDED_INT.incrementAndGet()).append(".").append(extension);
            try {
                URL url = this.toUrl(fileName.toString());
                ExtentCucumberAdapter.writeBytesToURL(event.data, url);
                try {
                    File f = new File(url.toURI());
                    stepTestThreadLocal.get().info("", MediaEntityBuilder.createScreenCaptureFromPath((String)f.getAbsolutePath()).build());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void writeBytesToURL(byte[] buf, URL url) throws IOException {
        OutputStream out = ExtentCucumberAdapter.createReportFileOutputStream(url);
        try {
            out.write(buf);
        }
        catch (IOException e) {
            throw new IOException("Unable to write to report file item: ", e);
        }
    }

    private static OutputStream createReportFileOutputStream(URL url) {
        try {
            return new URLOutputStream(url);
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private URL toUrl(String fileName) {
        try {
            Object prop = ExtentService.getProperty(SCREENSHOT_DIR_PROPERTY);
            String screenshotDir = prop == null ? "test-output/" : String.valueOf(prop);
            URL url = Paths.get(screenshotDir, fileName).toUri().toURL();
            return url;
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private void handleWrite(WriteEvent event) {
        String text = event.text;
        if (text != null && !text.isEmpty()) {
            stepTestThreadLocal.get().info(text);
        }
    }

    private void finishReport() {
        ExtentService.getInstance().flush();
    }

    private synchronized void handleStartOfFeature(TestCase testCase) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(testCase.getUri())) {
            this.currentFeatureFile.set(testCase.getUri());
            this.createFeature(testCase);
        }
    }

    private synchronized void createFeature(TestCase testCase) {
        gherkin.ast.Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            if (featureMap.containsKey(feature.getName())) {
                featureTestThreadLocal.set(featureMap.get(feature.getName()));
                return;
            }
            if (featureTestThreadLocal.get() != null && featureTestThreadLocal.get().getModel().getName().equals(feature.getName())) {
                return;
            }
            ExtentTest t = ExtentService.getInstance().createTest(Feature.class, feature.getName(), feature.getDescription());
            featureTestThreadLocal.set(t);
            featureMap.put(feature.getName(), t);
            List<String> tagList = this.createTagsList(feature.getTags());
            tagList.forEach(arg_0 -> ExtentCucumberAdapter.lambda$createFeature$0(featureTestThreadLocal.get(), arg_0));
        }
    }

    private List<String> createTagsList(List<Tag> tags) {
        ArrayList<String> tagList = new ArrayList<String>();
        for (Tag tag : tags) {
            tagList.add(tag.getName());
        }
        return tagList;
    }

    private synchronized void handleScenarioOutline(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testCase.getLine());
        if (TestSourcesModel.isScenarioOutlineScenario(astNode)) {
            ScenarioOutline scenarioOutline = (ScenarioOutline)TestSourcesModel.getScenarioDefinition(astNode);
            if (this.currentScenarioOutline.get() == null || !this.currentScenarioOutline.get().getName().equals(scenarioOutline.getName())) {
                scenarioOutlineThreadLocal.set(null);
                this.createScenarioOutline(scenarioOutline);
                this.currentScenarioOutline.set(scenarioOutline);
                this.addOutlineStepsToReport(scenarioOutline);
            }
            Examples examples = (Examples)astNode.parent.node;
            if (this.currentExamples.get() == null || !this.currentExamples.get().equals(examples)) {
                this.currentExamples.set(examples);
                this.createExamples(examples);
            }
        } else {
            scenarioOutlineThreadLocal.set(null);
            this.currentScenarioOutline.set(null);
            this.currentExamples.set(null);
        }
    }

    private synchronized void createScenarioOutline(ScenarioOutline scenarioOutline) {
        if (scenarioOutlineMap.containsKey(scenarioOutline.getName())) {
            scenarioOutlineThreadLocal.set(scenarioOutlineMap.get(scenarioOutline.getName()));
            return;
        }
        if (scenarioOutlineThreadLocal.get() == null) {
            ExtentTest t = featureTestThreadLocal.get().createNode(com.aventstack.extentreports.gherkin.model.ScenarioOutline.class, scenarioOutline.getName(), scenarioOutline.getDescription());
            scenarioOutlineThreadLocal.set(t);
            scenarioOutlineMap.put(scenarioOutline.getName(), t);
            List<String> tags = this.createTagsList(scenarioOutline.getTags());
            tags.forEach(arg_0 -> ExtentCucumberAdapter.lambda$createScenarioOutline$1(scenarioOutlineThreadLocal.get(), arg_0));
        }
    }

    private synchronized void addOutlineStepsToReport(ScenarioOutline scenarioOutline) {
        for (Step step : scenarioOutline.getSteps()) {
            if (step.getArgument() == null) continue;
            Node argument = step.getArgument();
            if (argument instanceof DocString) {
                this.createDocStringMap((DocString)argument);
                continue;
            }
            if (!(argument instanceof DataTable)) continue;
        }
    }

    private Map<String, Object> createDocStringMap(DocString docString) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        docStringMap.put("value", docString.getContent());
        return docStringMap;
    }

    private void createExamples(Examples examples) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        rows.add(examples.getTableHeader());
        rows.addAll(examples.getTableBody());
        String[][] data = this.getTable(rows);
        String markup = MarkupHelper.createTable((String[][])data).getMarkup();
        if (examples.getName() != null && !examples.getName().isEmpty()) {
            markup = examples.getName() + markup;
        }
        markup = scenarioOutlineThreadLocal.get().getModel().getDescription() + markup;
        scenarioOutlineThreadLocal.get().getModel().setDescription(markup);
    }

    private String[][] getTable(List<TableRow> rows) {
        String[][] data = null;
        int rowSize = rows.size();
        for (int i = 0; i < rowSize; ++i) {
            TableRow row = rows.get(i);
            List cells = row.getCells();
            int cellSize = cells.size();
            if (data == null) {
                data = new String[rowSize][cellSize];
            }
            for (int j = 0; j < cellSize; ++j) {
                data[i][j] = ((TableCell)cells.get(j)).getValue();
            }
        }
        return data;
    }

    private synchronized void createTestCase(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testCase.getLine());
        if (astNode != null) {
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            ExtentTest parent = scenarioOutlineThreadLocal.get() != null ? scenarioOutlineThreadLocal.get() : featureTestThreadLocal.get();
            ExtentTest t = parent.createNode(Scenario.class, scenarioDefinition.getName(), scenarioDefinition.getDescription());
            scenarioThreadLocal.set(t);
        }
        if (!testCase.getTags().isEmpty()) {
            testCase.getTags().forEach(x -> scenarioThreadLocal.get().assignCategory(new String[]{x.getName()}));
        }
    }

    private synchronized void createTestStep(PickleStepTestStep testStep) {
        String stepName = testStep.getStepText();
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile.get(), testStep.getStepLine());
        if (astNode != null) {
            Step step = (Step)astNode.node;
            try {
                String name = stepName == null || stepName.isEmpty() ? step.getText().replace("<", "&lt;").replace(">", "&gt;") : stepName;
                ExtentTest t = scenarioThreadLocal.get().createNode(new GherkinKeyword(step.getKeyword().trim()), step.getKeyword() + name, testStep.getCodeLocation());
                stepTestThreadLocal.set(t);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (!testStep.getStepArgument().isEmpty()) {
            Argument argument = (Argument)testStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                this.createDocStringMap((PickleString)argument);
            } else if (argument instanceof PickleTable) {
                List rows = ((PickleTable)argument).getRows();
                stepTestThreadLocal.get().pass(MarkupHelper.createTable((String[][])this.getPickleTable(rows)).getMarkup());
            }
        }
    }

    private String[][] getPickleTable(List<PickleRow> rows) {
        String[][] data = null;
        int rowSize = rows.size();
        for (int i = 0; i < rowSize; ++i) {
            PickleRow row = rows.get(i);
            List cells = row.getCells();
            int cellSize = cells.size();
            if (data == null) {
                data = new String[rowSize][cellSize];
            }
            for (int j = 0; j < cellSize; ++j) {
                data[i][j] = ((PickleCell)cells.get(j)).getValue();
            }
        }
        return data;
    }

    private Map<String, Object> createDocStringMap(PickleString docString) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        docStringMap.put("value", docString.getContent());
        return docStringMap;
    }

    private static /* synthetic */ void lambda$createScenarioOutline$1(ExtentTest rec$, String xva$0) {
        rec$.assignCategory(new String[]{xva$0});
    }

    private static /* synthetic */ void lambda$createFeature$0(ExtentTest rec$, String xva$0) {
        rec$.assignCategory(new String[]{xva$0});
    }
}

