/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.service;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.reporter.ExtentKlovReporter;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import com.aventstack.extentreports.reporter.JsonFormatter;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;

public class ExtentService
implements Serializable {
    private static final long serialVersionUID = -5008231199972325650L;
    private static Properties properties;

    public static synchronized ExtentReports getInstance() {
        return ExtentReportsLoader.INSTANCE;
    }

    public static Object getProperty(String key) {
        String sys = System.getProperty(key);
        return sys == null ? (properties == null ? null : properties.get(key)) : sys;
    }

    private ExtentReports readResolve() {
        return ExtentReportsLoader.INSTANCE;
    }

    static /* synthetic */ Properties access$0() {
        return properties;
    }

    private static class ExtentReportsLoader {
        private static final ExtentReports INSTANCE = new ExtentReports();
        private static final String[] DEFAULT_SETUP_PATH = new String[]{"extent.properties", "com/aventstack/adapter/extent.properties"};
        private static final String OUTPUT_PATH = "test-output/";
        private static final String EXTENT_REPORTER = "extent.reporter";
        private static final String START = "start";
        private static final String CONFIG = "config";
        private static final String OUT = "out";
        private static final String DELIM = ".";
        private static final String SPARK = "spark";
        private static final String INIT_SPARK_KEY = "extent.reporter.spark.start";
        private static final String CONFIG_SPARK_KEY = "extent.reporter.spark.config";
        private static final String OUT_SPARK_KEY = "extent.reporter.spark.out";
        private static final String JSONF = "json";
        private static final String INIT_JSONF_KEY = "extent.reporter.json.start";
        private static final String OUT_JSONF_KEY = "extent.reporter.json.out";
        private static final String KLOV = "klov";
        private static final String INIT_KLOV_KEY = "extent.reporter.klov.start";
        private static final String CONFIG_KLOV_KEY = "extent.reporter.klov.config";

        static {
            ExtentReportsLoader.createViaProperties();
            ExtentReportsLoader.createViaSystem();
        }

        private ExtentReportsLoader() {
        }

        private static void createViaProperties() {
            ClassLoader loader = ExtentReportsLoader.class.getClassLoader();
            Optional<InputStream> is = Arrays.stream(DEFAULT_SETUP_PATH).map(x -> loader.getResourceAsStream((String)x)).filter(x -> x != null).findFirst();
            if (is.isPresent()) {
                Properties properties = new Properties();
                try {
                    properties.load(is.get());
                    ExtentService.properties = properties;
                    if (properties.containsKey(INIT_SPARK_KEY) && "true".equals(String.valueOf(properties.get(INIT_SPARK_KEY)))) {
                        ExtentReportsLoader.initSpark(properties);
                    }
                    if (properties.containsKey(INIT_JSONF_KEY) && "true".equals(String.valueOf(properties.get(INIT_JSONF_KEY)))) {
                        ExtentReportsLoader.initJsonf(properties);
                    }
                    if (properties.containsKey(INIT_KLOV_KEY) && "true".equals(String.valueOf(properties.get(INIT_KLOV_KEY)))) {
                        ExtentReportsLoader.initKlov(properties);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private static void createViaSystem() {
            if ("true".equals(System.getProperty(INIT_SPARK_KEY))) {
                ExtentReportsLoader.initSpark(null);
            }
            if ("true".equals(System.getProperty(INIT_JSONF_KEY))) {
                ExtentReportsLoader.initJsonf(null);
            }
            if ("true".equals(System.getProperty(INIT_KLOV_KEY))) {
                ExtentReportsLoader.initKlov(null);
            }
        }

        private static String getOutputPath(Properties properties, String key) {
            String out = properties != null && properties.get(key) != null ? String.valueOf(properties.get(key)) : System.getProperty(key);
            out = out == null || out.equals("null") || out.isEmpty() ? OUTPUT_PATH + key.split("\\.")[2] + "/" : out;
            return out;
        }

        private static void initSpark(Properties properties) {
            String out = ExtentReportsLoader.getOutputPath(properties, OUT_SPARK_KEY);
            ExtentSparkReporter spark = new ExtentSparkReporter(out);
            spark.config().enableOfflineMode(Boolean.valueOf(true));
            ExtentReportsLoader.attach((ReporterConfigurable)spark, properties, CONFIG_SPARK_KEY);
        }

        private static void initJsonf(Properties properties) {
            String out = ExtentReportsLoader.getOutputPath(properties, OUT_JSONF_KEY);
            JsonFormatter jsonf = new JsonFormatter(out);
            INSTANCE.attachReporter(new ExtentObserver[]{jsonf});
        }

        private static void initKlov(Properties properties) {
            ExtentKlovReporter klov = new ExtentKlovReporter("Default");
            String configPath = properties == null ? System.getProperty(CONFIG_KLOV_KEY) : String.valueOf(properties.get(CONFIG_KLOV_KEY));
            File f = new File(configPath);
            if (configPath != null && !configPath.isEmpty() && f.exists()) {
                Object prop = ExtentService.getProperty("screenshot.dir");
                String screenshotDir = prop == null ? OUTPUT_PATH : String.valueOf(prop);
                String url = Paths.get(screenshotDir, new String[0]).toString();
                ExtentService.getInstance().tryResolveMediaPath(new String[]{url});
                try {
                    FileInputStream is = new FileInputStream(f);
                    klov.loadInitializationParams((InputStream)is);
                    INSTANCE.attachReporter(new ExtentObserver[]{klov});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private static void attach(ReporterConfigurable r, Properties properties, String configKey) {
            Object configPath;
            Object object = configPath = properties == null ? System.getProperty(configKey) : properties.get(configKey);
            if (configPath != null && !String.valueOf(configPath).isEmpty()) {
                try {
                    r.loadXMLConfig(String.valueOf(configPath));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            INSTANCE.attachReporter(new ExtentObserver[]{(ExtentObserver)r});
        }
    }
}

