/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.testng.listener;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.service.ExtentService;
import com.aventstack.extentreports.testng.listener.commons.ExtentTestCommons;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.xml.XmlSuite;

public class ExtentIReporterSuiteListenerAdapter
implements IReporter {
    private static final Calendar CALENDAR = Calendar.getInstance();

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        ExtentService.getInstance().setReportUsesManualConfiguration(true);
        ExtentService.getInstance().setAnalysisStrategy(AnalysisStrategy.SUITE);
        for (ISuite suite : suites) {
            Map result = suite.getResults();
            for (ISuiteResult r : result.values()) {
                ITestContext context = r.getTestContext();
                ExtentTest suiteTest = ExtentService.getInstance().createTest(r.getTestContext().getSuite().getName());
                this.buildTestNodes(suiteTest, context.getFailedTests(), Status.FAIL);
                this.buildTestNodes(suiteTest, context.getSkippedTests(), Status.SKIP);
                this.buildTestNodes(suiteTest, context.getPassedTests(), Status.PASS);
            }
        }
        for (String s : Reporter.getOutput()) {
            ExtentService.getInstance().setTestRunnerOutput(s);
        }
        ExtentService.getInstance().flush();
    }

    private void buildTestNodes(ExtentTest suiteTest, IResultMap tests, Status status) {
        if (tests.size() > 0) {
            for (ITestResult result : tests.getAllResults()) {
                ExtentTest node = suiteTest.createNode(result.getMethod().getMethodName(), result.getMethod().getDescription());
                String[] groups = result.getMethod().getGroups();
                ExtentTestCommons.assignGroups(node, groups);
                if (result.getThrowable() != null) {
                    node.log(status, result.getThrowable());
                } else {
                    node.log(status, "Test " + status.toString().toLowerCase() + "ed");
                }
                node.getModel().getLogContext().getAll().forEach(x -> x.setTimestamp(this.getTime(result.getEndMillis())));
                node.getModel().setStartTime(this.getTime(result.getStartMillis()));
                node.getModel().setEndTime(this.getTime(result.getEndMillis()));
            }
        }
    }

    private Date getTime(long millis) {
        CALENDAR.setTimeInMillis(millis);
        return CALENDAR.getTime();
    }
}

