/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Test;
import java.util.List;

public class SessionStatusStats {
    List<Test> testList;
    int parentPass = 0;
    int parentFail = 0;
    int parentFatal = 0;
    int parentError = 0;
    int parentWarning = 0;
    int parentSkip = 0;
    int parentUnknown = 0;
    int childPass = 0;
    int childFail = 0;
    int childFatal = 0;
    int childError = 0;
    int childWarning = 0;
    int childSkip = 0;
    int childUnknown = 0;
    int childInfo = 0;
    int grandChildPass = 0;
    int grandChildFail = 0;
    int grandChildFatal = 0;
    int grandChildError = 0;
    int grandChildWarning = 0;
    int grandChildSkip = 0;
    int grandChildUnknown = 0;
    int grandChildInfo = 0;

    public SessionStatusStats(List<Test> testList) {
        this.testList = testList;
        this.updateCounts();
    }

    public int getParentCount() {
        return this.getParentCountPass() + this.getParentCountFail() + this.getParentCountFatal() + this.getParentCountError() + this.getParentCountWarning() + this.getParentCountSkip() + this.getParentCountUnknown();
    }

    public int getParentCountPass() {
        return this.parentPass;
    }

    public int getParentCountFail() {
        return this.parentFail;
    }

    public int getParentCountFatal() {
        return this.parentFatal;
    }

    public int getParentCountError() {
        return this.parentError;
    }

    public int getParentCountWarning() {
        return this.parentWarning;
    }

    public int getParentCountSkip() {
        return this.parentSkip;
    }

    public int getParentCountUnknown() {
        return this.parentUnknown;
    }

    public int getChildCount() {
        return this.getChildCountPass() + this.getChildCountFail() + this.getChildCountFatal() + this.getChildCountError() + this.getChildCountWarning() + this.getChildCountSkip() + this.getChildCountInfo() + this.getChildCountUnknown();
    }

    public int getChildCountPass() {
        return this.childPass;
    }

    public int getChildCountFail() {
        return this.childFail;
    }

    public int getChildCountFatal() {
        return this.childFatal;
    }

    public int getChildCountError() {
        return this.childError;
    }

    public int getChildCountWarning() {
        return this.childWarning;
    }

    public int getChildCountSkip() {
        return this.childSkip;
    }

    public int getChildCountUnknown() {
        return this.childUnknown;
    }

    public int getChildCountInfo() {
        return this.childInfo;
    }

    public int getGrandChildCount() {
        return this.getGrandChildCountPass() + this.getGrandChildCountFail() + this.getGrandChildCountFatal() + this.getGrandChildCountError() + this.getGrandChildCountWarning() + this.getGrandChildCountSkip() + this.getGrandChildCountInfo() + this.getGrandChildCountUnknown();
    }

    public int getGrandChildCountPass() {
        return this.grandChildPass;
    }

    public int getGrandChildCountFail() {
        return this.grandChildFail;
    }

    public int getGrandChildCountFatal() {
        return this.grandChildFatal;
    }

    public int getGrandChildCountError() {
        return this.grandChildError;
    }

    public int getGrandChildCountWarning() {
        return this.grandChildWarning;
    }

    public int getGrandChildCountSkip() {
        return this.grandChildSkip;
    }

    public int getGrandChildCountUnknown() {
        return this.grandChildUnknown;
    }

    public int getGrandChildCountInfo() {
        return this.grandChildInfo;
    }

    void updateCounts() {
        this.testList.forEach(this::addTestForStatusStatsUpdate);
    }

    void addTestForStatusStatsUpdate(Test test) {
        if (test.isBehaviorDrivenType() || test.hasChildren() && test.getNodeContext().get(0).isBehaviorDrivenType()) {
            this.updateGroupCountsBDD(test);
            return;
        }
        this.updateGroupCounts(test);
    }

    void updateGroupCountsBDD(Test test) {
        this.incrementItemCountByStatus(ItemLevel.PARENT, test.getStatus());
        if (test.hasChildren()) {
            test.getNodeContext().getAll().forEach(x -> {
                this.incrementItemCountByStatus(ItemLevel.CHILD, x.getStatus());
                if (x.getNodeContext() != null && x.getNodeContext().getAll().size() > 0) {
                    x.getNodeContext().getAll().forEach(n -> n.getLogContext().getAll().forEach(l -> this.incrementItemCountByStatus(ItemLevel.GRANDCHILD, l.getStatus())));
                }
            });
        }
    }

    void updateGroupCounts(Test test) {
        if (!test.hasChildren()) {
            this.incrementItemCountByStatus(ItemLevel.PARENT, test.getStatus());
            test.getLogContext().getAll().forEach(x -> this.incrementItemCountByStatus(ItemLevel.CHILD, x.getStatus()));
        } else {
            test.getNodeContext().getAll().forEach(this::updateGroupCounts);
        }
    }

    void incrementItemCountByStatus(ItemLevel item, Status status) {
        switch (item) {
            case PARENT: {
                this.incrementParent(status);
                break;
            }
            case CHILD: {
                this.incrementChild(status);
                break;
            }
            case GRANDCHILD: {
                this.incrementGrandChild(status);
                break;
            }
        }
    }

    void incrementParent(Status status) {
        switch (status) {
            case PASS: {
                ++this.parentPass;
                break;
            }
            case FAIL: {
                ++this.parentFail;
                break;
            }
            case FATAL: {
                ++this.parentFatal;
                break;
            }
            case ERROR: {
                ++this.parentError;
                break;
            }
            case WARNING: {
                ++this.parentWarning;
                break;
            }
            case SKIP: {
                ++this.parentSkip;
                break;
            }
            case UNKNOWN: {
                ++this.parentUnknown;
                break;
            }
        }
    }

    void incrementChild(Status status) {
        switch (status) {
            case PASS: {
                ++this.childPass;
                break;
            }
            case FAIL: {
                ++this.childFail;
                break;
            }
            case FATAL: {
                ++this.childFatal;
                break;
            }
            case ERROR: {
                ++this.childError;
                break;
            }
            case WARNING: {
                ++this.childWarning;
                break;
            }
            case SKIP: {
                ++this.childSkip;
                break;
            }
            case UNKNOWN: {
                ++this.childUnknown;
                break;
            }
            case INFO: {
                ++this.childInfo;
                break;
            }
        }
    }

    void incrementGrandChild(Status status) {
        switch (status) {
            case PASS: {
                ++this.grandChildPass;
                break;
            }
            case FAIL: {
                ++this.grandChildFail;
                break;
            }
            case FATAL: {
                ++this.grandChildFatal;
                break;
            }
            case ERROR: {
                ++this.grandChildError;
                break;
            }
            case WARNING: {
                ++this.grandChildWarning;
                break;
            }
            case SKIP: {
                ++this.grandChildSkip;
                break;
            }
            case UNKNOWN: {
                ++this.grandChildUnknown;
                break;
            }
            case INFO: {
                ++this.grandChildInfo;
                break;
            }
        }
    }

    static enum ItemLevel {
        PARENT,
        CHILD,
        GRANDCHILD;

    }
}

