/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.model.SystemAttribute;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class SystemAttributeContext {
    List<SystemAttribute> saList = new ArrayList<SystemAttribute>();

    public SystemAttributeContext() {
        SystemAttribute sa = new SystemAttribute();
        sa.setName("User Name");
        sa.setValue(System.getProperty("user.name"));
        this.saList.add(sa);
        sa = new SystemAttribute();
        sa.setName("OS");
        sa.setValue(System.getProperty("os.name"));
        this.saList.add(sa);
        sa = new SystemAttribute();
        sa.setName("Java Version");
        sa.setValue(System.getProperty("java.version"));
        this.saList.add(sa);
        sa = new SystemAttribute();
        sa.setName("Host Name");
        try {
            sa.setValue(InetAddress.getLocalHost().getHostName());
            this.saList.add(sa);
        }
        catch (Exception e) {
            sa.setValue("");
            this.saList.add(sa);
        }
    }

    public void setSystemAttribute(SystemAttribute sa) {
        this.saList.add(sa);
    }

    public List<SystemAttribute> getSystemAttributeList() {
        return this.saList;
    }
}

