/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.configuration.Config;
import com.aventstack.extentreports.configuration.ConfigMap;
import com.aventstack.extentreports.mediastorage.MediaStorage;
import com.aventstack.extentreports.mediastorage.MediaStorageManagerFactory;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.configuration.ExtentXReporterConfiguration;
import com.aventstack.extentreports.utils.MongoUtil;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class ExtentXReporter
extends AbstractReporter {
    private static final String DEFAULT_CONFIG_FILE = "extentx-config.properties";
    private static final String DEFAULT_PROJECT_NAME = "Default";
    private String url;
    private Map<String, ObjectId> categoryNameObjectIdCollection;
    private ObjectId reportId;
    private ObjectId projectId;
    private MongoClient mongoClient;
    private MongoDatabase db;
    private MongoCollection<Document> projectCollection;
    private MongoCollection<Document> reportCollection;
    private MongoCollection<Document> testCollection;
    private MongoCollection<Document> nodeCollection;
    private MongoCollection<Document> logCollection;
    private MongoCollection<Document> mediaCollection;
    private MongoCollection<Document> categoryCollection;
    private MongoCollection<Document> authorCollection;
    private MongoCollection<Document> categoryTestsTestCategories;
    private MongoCollection<Document> authorTestsTestAuthors;
    private MediaStorage media;
    private ExtentXReporterConfiguration userConfig;

    ExtentXReporter() {
        this.loadDefaultConfig();
    }

    public ExtentXReporter(String host) {
        this();
        this.mongoClient = new MongoClient(host, 27017);
    }

    public ExtentXReporter(String host, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(host, options);
    }

    public ExtentXReporter(String host, int port) {
        this();
        this.mongoClient = new MongoClient(host, port);
    }

    public ExtentXReporter(MongoClientURI uri) {
        this();
        this.mongoClient = new MongoClient(uri);
    }

    public ExtentXReporter(ServerAddress addr) {
        this();
        this.mongoClient = new MongoClient(addr);
    }

    public ExtentXReporter(List<ServerAddress> seeds) {
        this();
        this.mongoClient = new MongoClient(seeds);
    }

    public ExtentXReporter(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this();
        this.mongoClient = new MongoClient(seeds, credentialsList);
    }

    public ExtentXReporter(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(seeds, credentialsList, options);
    }

    public ExtentXReporter(List<ServerAddress> seeds, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(seeds, options);
    }

    public ExtentXReporter(ServerAddress addr, List<MongoCredential> credentialsList) {
        this();
        this.mongoClient = new MongoClient(addr, credentialsList);
    }

    public ExtentXReporter(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(addr, credentialsList, options);
    }

    public ExtentXReporter(ServerAddress addr, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(addr, options);
    }

    public ExtentXReporterConfiguration config() {
        return this.userConfig;
    }

    @Override
    public void start() {
        this.loadUserConfig();
        this.db = this.mongoClient.getDatabase("extent");
        this.projectCollection = this.db.getCollection("project");
        this.reportCollection = this.db.getCollection("report");
        this.testCollection = this.db.getCollection("test");
        this.nodeCollection = this.db.getCollection("node");
        this.logCollection = this.db.getCollection("log");
        this.mediaCollection = this.db.getCollection("media");
        this.categoryCollection = this.db.getCollection("category");
        this.authorCollection = this.db.getCollection("author");
        this.categoryTestsTestCategories = this.db.getCollection("category_tests__test_categories");
        this.authorTestsTestAuthors = this.db.getCollection("author_tests__test_authors");
        this.setupProject();
    }

    private void loadDefaultConfig() {
        this.configContext = new ConfigMap();
        this.userConfig = new ExtentXReporterConfiguration();
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = loader.getResourceAsStream(DEFAULT_CONFIG_FILE);
        this.loadConfig(is);
    }

    private void loadUserConfig() {
        this.userConfig.getConfigMap().forEach((k, v) -> {
            if (v != null) {
                Config c = new Config();
                c.setKey((String)k);
                c.setValue(v);
                this.configContext.setConfig(c);
            }
        });
    }

    private void setupProject() {
        Document doc;
        FindIterable iterable;
        Document project;
        String projectName = this.configContext.getValue("projectName").toString().trim();
        if (projectName == null || projectName.isEmpty()) {
            projectName = DEFAULT_PROJECT_NAME;
        }
        if ((project = (Document)(iterable = this.projectCollection.find((Bson)(doc = new Document("name", (Object)projectName)))).first()) != null) {
            this.projectId = project.getObjectId((Object)"_id");
        } else {
            this.projectCollection.insertOne((Object)doc);
            this.projectId = MongoUtil.getId(doc);
        }
        this.setupReport(projectName);
    }

    private void setupReport(String projectName) {
        FindIterable iterable;
        Document report;
        Object id;
        String reportName = this.configContext.getValue("reportName").toString().trim();
        if (reportName == null || reportName.isEmpty()) {
            reportName = projectName + " - " + Calendar.getInstance().getTimeInMillis();
        }
        if ((id = this.configContext.getValue("reportId")) != null && !id.toString().isEmpty() && (report = (Document)(iterable = this.reportCollection.find((Bson)new Document("_id", (Object)new ObjectId(id.toString())))).first()) != null) {
            this.reportId = report.getObjectId((Object)"_id");
            return;
        }
        Document doc = new Document("fileName", (Object)reportName).append("startTime", (Object)this.getStartTime()).append("project", (Object)this.projectId);
        this.reportCollection.insertOne((Object)doc);
        this.reportId = MongoUtil.getId(doc);
    }

    @Override
    public void stop() {
        this.mongoClient.close();
    }

    @Override
    public synchronized void flush() {
        this.setEndTime(Calendar.getInstance().getTime());
        Document doc = new Document("endTime", (Object)this.getEndTime()).append("parentLength", (Object)this.sc.getParentCount()).append("passParentLength", (Object)this.sc.getParentCountPass()).append("failParentLength", (Object)this.sc.getParentCountFail()).append("fatalParentLength", (Object)this.sc.getParentCountFatal()).append("errorParentLength", (Object)this.sc.getParentCountError()).append("warningParentLength", (Object)this.sc.getParentCountWarning()).append("skipParentLength", (Object)this.sc.getParentCountSkip()).append("unknownParentLength", (Object)this.sc.getParentCountUnknown()).append("childLength", (Object)this.sc.getChildCount()).append("passChildLength", (Object)this.sc.getChildCountPass()).append("failChildLength", (Object)this.sc.getChildCountFail()).append("fatalChildLength", (Object)this.sc.getChildCountFatal()).append("errorChildLength", (Object)this.sc.getChildCountError()).append("warningChildLength", (Object)this.sc.getChildCountWarning()).append("skipChildLength", (Object)this.sc.getChildCountSkip()).append("unknownChildLength", (Object)this.sc.getChildCountUnknown()).append("infoChildLength", (Object)this.sc.getChildCountInfo()).append("grandChildLength", (Object)this.sc.getGrandChildCount()).append("passGrandChildLength", (Object)this.sc.getGrandChildCountPass()).append("failGrandChildLength", (Object)this.sc.getGrandChildCountFail()).append("fatalGrandChildLength", (Object)this.sc.getGrandChildCountFatal()).append("errorGrandChildLength", (Object)this.sc.getGrandChildCountError()).append("warningGrandChildLength", (Object)this.sc.getGrandChildCountWarning()).append("skipGrandChildLength", (Object)this.sc.getGrandChildCountSkip()).append("unknownGrandChildLength", (Object)this.sc.getGrandChildCountUnknown()).append("infoGrandChildLength", (Object)this.sc.getGrandChildCountInfo());
        this.reportCollection.updateOne((Bson)new Document("_id", (Object)this.reportId), (Bson)new Document("$set", (Object)doc));
    }

    @Override
    public void onTestStarted(Test test) {
        Document doc = new Document("report", (Object)this.reportId).append("name", (Object)test.getName()).append("status", (Object)test.getStatus().toString()).append("description", (Object)test.getDescription()).append("startTime", (Object)test.getStartTime()).append("endTime", (Object)test.getEndTime()).append("childNodesCount", (Object)test.getNodeContext().getAll().size());
        this.testCollection.insertOne((Object)doc);
        ObjectId testId = MongoUtil.getId(doc);
        test.setObjectId(testId);
    }

    @Override
    public synchronized void onNodeStarted(Test node) {
        Document doc = new Document("test", (Object)node.getParent().getObjectId()).append("parentTestName", (Object)node.getParent().getName()).append("report", (Object)this.reportId).append("name", (Object)node.getName()).append("level", (Object)node.getLevel()).append("status", (Object)node.getStatus().toString()).append("description", (Object)node.getDescription()).append("startTime", (Object)node.getStartTime()).append("endTime", (Object)node.getEndTime());
        this.nodeCollection.insertOne((Object)doc);
        ObjectId nodeId = MongoUtil.getId(doc);
        node.setObjectId(nodeId);
    }

    @Override
    public synchronized void onLogAdded(Test test, Log log) {
        String model = "test";
        if (test.getLevel() > 0) {
            model = "node";
        }
        Document doc = new Document(model, (Object)test.getObjectId()).append("report", (Object)this.reportId).append("testName", (Object)test.getName()).append("logSequence", (Object)log.getSequence()).append("status", (Object)log.getStatus().toString()).append("timestamp", (Object)log.getTimestamp()).append("stepName", (Object)log.getStepName()).append("details", (Object)log.getDetails());
        this.logCollection.insertOne((Object)doc);
        this.endTestRecursive(test);
    }

    private void endTestRecursive(Test test) {
        Document doc = new Document("status", (Object)test.getStatus().toString()).append("endTime", (Object)test.getEndTime());
        if (test.getLevel() == 0) {
            this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
        } else {
            this.nodeCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
            this.endTestRecursive(test.getParent());
        }
    }

    @Override
    public void onCategoryAssigned(Test test, Category category) {
        Document doc;
        if (this.categoryNameObjectIdCollection == null) {
            this.categoryNameObjectIdCollection = new HashMap<String, ObjectId>();
        }
        if (!this.categoryNameObjectIdCollection.containsKey(category.getName())) {
            doc = new Document("report", (Object)this.reportId).append("name", (Object)category.getName());
            FindIterable iterable = this.categoryCollection.find((Bson)doc);
            Document docCategory = (Document)iterable.first();
            if (docCategory != null) {
                this.categoryNameObjectIdCollection.put(category.getName(), docCategory.getObjectId((Object)"_id"));
            } else {
                doc = new Document("tests", (Object)test.getObjectId()).append("report", (Object)this.reportId).append("name", (Object)category.getName()).append("status", (Object)test.getStatus().toString()).append("testName", (Object)test.getName());
                this.categoryCollection.insertOne((Object)doc);
                ObjectId categoryId = MongoUtil.getId(doc);
                this.categoryNameObjectIdCollection.put(category.getName(), categoryId);
            }
        }
        doc = new Document("test_categories", (Object)test.getObjectId()).append("category_tests", (Object)this.categoryNameObjectIdCollection.get(category.getName())).append("category", (Object)category.getName()).append("test", (Object)test.getName());
        this.categoryTestsTestCategories.insertOne((Object)doc);
    }

    @Override
    public void onAuthorAssigned(Test test, Author author) {
        Document doc = new Document("tests", (Object)test.getObjectId()).append("report", (Object)this.reportId).append("name", (Object)author.getName()).append("status", (Object)test.getStatus().toString()).append("testName", (Object)test.getName());
        this.authorCollection.insertOne((Object)doc);
        ObjectId authorId = MongoUtil.getId(doc);
        doc = new Document("test_authors", (Object)test.getObjectId()).append("author_tests", (Object)authorId).append("author", (Object)author.getName()).append("test", (Object)test.getName());
        this.authorTestsTestAuthors.insertOne((Object)doc);
    }

    @Override
    public void onScreenCaptureAdded(Test test, ScreenCapture screenCapture) throws IOException {
        this.storeUrl();
        screenCapture.setReportObjectId(this.reportId);
        this.createMedia(test, screenCapture);
        if (this.media == null) {
            this.media = new MediaStorageManagerFactory().getManager("http");
            this.media.init(this.url);
        }
        this.media.storeMedia(screenCapture);
    }

    private void storeUrl() throws IOException {
        if (this.url == null) {
            Object url = this.configContext.getValue("serverUrl");
            if (url == null) {
                throw new IOException("server url cannot be null, use extentxConfig.setServerUrl(url)");
            }
            this.url = url.toString().trim();
        }
    }

    private void createMedia(Test test, ScreenCapture screenCapture) {
        String model = "test";
        if (test.getLevel() > 0) {
            model = "node";
        }
        Document doc = new Document(model, (Object)test.getObjectId()).append("report", (Object)this.reportId).append("testName", (Object)test.getName()).append("sequence", (Object)screenCapture.getSequence());
        this.mediaCollection.insertOne((Object)doc);
        ObjectId mediaId = MongoUtil.getId(doc);
        screenCapture.setObjectId(mediaId);
    }

    @Override
    public void setTestList(List<Test> reportTestList) {
        this.testList = reportTestList;
    }

    public List<Test> getTestList() {
        if (this.testList == null) {
            this.testList = new ArrayList();
        }
        return this.testList;
    }

    static {
        Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
        mongoLogger.setLevel(Level.SEVERE);
    }
}

