/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.MediaEntityModelProvider;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.MediaType;
import com.aventstack.extentreports.model.ScreenCapture;
import java.io.IOException;

public class MediaEntityBuilder {
    private static ThreadLocal<Media> media;

    private MediaEntityBuilder() {
    }

    private static MediaEntityBuilder getInstance() {
        return MediaBuilderInstance.INSTANCE;
    }

    public MediaEntityModelProvider build() {
        return new MediaEntityModelProvider(media.get());
    }

    public static MediaEntityBuilder createScreenCaptureFromPath(String path, String title) throws IOException {
        if (path == null || path.isEmpty()) {
            throw new IOException("ScreenCapture path cannot be null or empty.");
        }
        ScreenCapture sc = new ScreenCapture();
        sc.setMediaType(MediaType.IMG);
        sc.setPath(path);
        if (title != null) {
            sc.setName(title);
        }
        media = new ThreadLocal();
        media.set(sc);
        return MediaEntityBuilder.getInstance();
    }

    public static MediaEntityBuilder createScreenCaptureFromPath(String path) throws IOException {
        return MediaEntityBuilder.createScreenCaptureFromPath(path, null);
    }

    /* synthetic */ MediaEntityBuilder(MediaEntityBuilder mediaEntityBuilder) {
        this();
    }

    private static class MediaBuilderInstance {
        static final MediaEntityBuilder INSTANCE = new MediaEntityBuilder(null);

        private MediaBuilderInstance() {
        }
    }
}

