/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.RunResult;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.model.AbstractStructure;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.Test;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class Log
implements RunResult,
Serializable {
    private static final long serialVersionUID = 1594512136869286425L;
    private AbstractStructure<ScreenCapture> screenCaptureContext;
    private AbstractStructure<Screencast> screencastContext;
    private ExtentTest parent;
    private Test parentModel;
    private Markup markup;
    private Date timestamp = Calendar.getInstance().getTime();
    private Status logStatus;
    private String stepName;
    private String details;
    private int sequence;

    private Log() {
    }

    public Log(Test test) {
        this();
        this.parentModel = test;
    }

    public Log(ExtentTest test) {
        this();
        this.parent = test;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setStatus(Status logStatus) {
        this.logStatus = logStatus;
    }

    @Override
    public Status getStatus() {
        return this.logStatus;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getDetails() {
        return this.details;
    }

    public void setMarkup(Markup markup) {
        this.markup = markup;
    }

    public Markup getMarkup() {
        return this.markup;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setScreenCapture(ScreenCapture sc) {
        if (this.screenCaptureContext == null) {
            this.screenCaptureContext = new AbstractStructure();
        }
        this.screenCaptureContext.add(sc);
        String details = this.getDetails().isEmpty() ? sc.getSource() : String.valueOf(this.getDetails()) + sc.getSource();
        this.setDetails(details);
    }

    public AbstractStructure<ScreenCapture> getScreenCaptureContext() {
        return this.screenCaptureContext;
    }

    public void setScreencast(Screencast sc) {
        if (this.screencastContext == null) {
            this.screencastContext = new AbstractStructure();
        }
        this.screencastContext.add(sc);
        String details = this.getDetails().isEmpty() ? sc.getSource() : String.valueOf(this.getDetails()) + sc.getSource();
        this.setDetails(details);
    }

    public AbstractStructure<Screencast> getScreencastContext() {
        return this.screencastContext;
    }

    public ExtentTest getParent() {
        return this.parent;
    }

    public Test getParentModel() {
        if (this.parent == null) {
            return this.parentModel;
        }
        return this.parent.getModel();
    }
}

