/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Test;
import java.util.List;

public class SessionStatusStats {
    private List<Test> testCollection;
    private int parentPass = 0;
    private int parentFail = 0;
    private int parentFatal = 0;
    private int parentError = 0;
    private int parentWarning = 0;
    private int parentSkip = 0;
    private int parentExceptions = 0;
    private int childPass = 0;
    private int childFail = 0;
    private int childFatal = 0;
    private int childError = 0;
    private int childWarning = 0;
    private int childSkip = 0;
    private int childInfo = 0;
    private int childExceptions = 0;
    private int grandChildPass = 0;
    private int grandChildFail = 0;
    private int grandChildFatal = 0;
    private int grandChildError = 0;
    private int grandChildWarning = 0;
    private int grandChildSkip = 0;
    private int grandChildInfo = 0;
    private int grandChildExceptions = 0;

    public void refresh(List<Test> testCollection) {
        this.reset();
        this.testCollection = testCollection;
        this.updateCounts();
    }

    private void reset() {
        this.parentPass = 0;
        this.parentFail = 0;
        this.parentFatal = 0;
        this.parentError = 0;
        this.parentWarning = 0;
        this.parentSkip = 0;
        this.parentExceptions = 0;
        this.childPass = 0;
        this.childFail = 0;
        this.childFatal = 0;
        this.childError = 0;
        this.childWarning = 0;
        this.childSkip = 0;
        this.childInfo = 0;
        this.childExceptions = 0;
        this.grandChildPass = 0;
        this.grandChildFail = 0;
        this.grandChildFatal = 0;
        this.grandChildError = 0;
        this.grandChildWarning = 0;
        this.grandChildSkip = 0;
        this.grandChildInfo = 0;
        this.grandChildExceptions = 0;
    }

    public int getParentCount() {
        return this.getParentCountPass() + this.getParentCountFail() + this.getParentCountFatal() + this.getParentCountError() + this.getParentCountWarning() + this.getParentCountSkip();
    }

    public int getParentCountPass() {
        return this.parentPass;
    }

    public int getParentCountFail() {
        return this.parentFail;
    }

    public int getParentCountFatal() {
        return this.parentFatal;
    }

    public int getParentCountError() {
        return this.parentError;
    }

    public int getParentCountWarning() {
        return this.parentWarning;
    }

    public int getParentCountSkip() {
        return this.parentSkip;
    }

    public int getParentCountExceptions() {
        return this.parentExceptions;
    }

    public int getChildCount() {
        return this.getChildCountPass() + this.getChildCountFail() + this.getChildCountFatal() + this.getChildCountError() + this.getChildCountWarning() + this.getChildCountSkip() + this.getChildCountInfo();
    }

    public int getChildCountPass() {
        return this.childPass;
    }

    public int getChildCountFail() {
        return this.childFail;
    }

    public int getChildCountFatal() {
        return this.childFatal;
    }

    public int getChildCountError() {
        return this.childError;
    }

    public int getChildCountWarning() {
        return this.childWarning;
    }

    public int getChildCountSkip() {
        return this.childSkip;
    }

    public int getChildCountInfo() {
        return this.childInfo;
    }

    public int getChildCountExceptions() {
        return this.childExceptions;
    }

    public int getGrandChildCount() {
        return this.getGrandChildCountPass() + this.getGrandChildCountFail() + this.getGrandChildCountFatal() + this.getGrandChildCountError() + this.getGrandChildCountWarning() + this.getGrandChildCountSkip() + this.getGrandChildCountInfo();
    }

    public int getGrandChildCountPass() {
        return this.grandChildPass;
    }

    public int getGrandChildCountFail() {
        return this.grandChildFail;
    }

    public int getGrandChildCountFatal() {
        return this.grandChildFatal;
    }

    public int getGrandChildCountError() {
        return this.grandChildError;
    }

    public int getGrandChildCountWarning() {
        return this.grandChildWarning;
    }

    public int getGrandChildCountSkip() {
        return this.grandChildSkip;
    }

    public int getGrandChildCountInfo() {
        return this.grandChildInfo;
    }

    public int getGrandChildCountExceptions() {
        return this.grandChildExceptions;
    }

    void updateCounts() {
        this.testCollection.forEach(this::addTestForStatusStatsUpdate);
    }

    void addTestForStatusStatsUpdate(Test test) {
        if (test.isBehaviorDrivenType() || test.hasChildren() && test.getNodeContext().get(0).isBehaviorDrivenType()) {
            this.updateGroupCountsBDD(test);
            return;
        }
        this.updateGroupCounts(test);
    }

    void updateGroupCountsBDD(Test test) {
        this.incrementItemCountByStatus(ItemLevel.PARENT, test.getStatus());
        if (test.hasChildren()) {
            test.getNodeContext().getAll().forEach(x -> {
                this.incrementItemCountByStatus(ItemLevel.CHILD, x.getStatus());
                if (x.getNodeContext() != null && x.getNodeContext().getAll().size() > 0) {
                    x.getNodeContext().getAll().forEach(n -> n.getLogContext().getAll().forEach(l -> this.incrementItemCountByStatus(ItemLevel.GRANDCHILD, l.getStatus())));
                }
            });
        }
    }

    void updateGroupCounts(Test test) {
        if (!test.hasChildren()) {
            this.incrementItemCountByStatus(ItemLevel.PARENT, test.getStatus());
            test.getLogContext().getAll().forEach(x -> this.incrementItemCountByStatus(ItemLevel.CHILD, x.getStatus()));
        } else {
            test.getNodeContext().getAll().forEach(this::updateGroupCounts);
        }
    }

    void incrementItemCountByStatus(ItemLevel item, Status status) {
        switch (item) {
            case PARENT: {
                this.incrementParent(status);
                break;
            }
            case CHILD: {
                this.incrementChild(status);
                break;
            }
            case GRANDCHILD: {
                this.incrementGrandChild(status);
                break;
            }
        }
    }

    void incrementParent(Status status) {
        switch (status) {
            case PASS: {
                ++this.parentPass;
                return;
            }
            case FAIL: {
                ++this.parentFail;
                break;
            }
            case FATAL: {
                ++this.parentFatal;
                break;
            }
            case ERROR: {
                ++this.parentError;
                break;
            }
            case WARNING: {
                ++this.parentWarning;
                break;
            }
            case SKIP: {
                ++this.parentSkip;
                break;
            }
        }
        ++this.parentExceptions;
    }

    void incrementChild(Status status) {
        switch (status) {
            case PASS: {
                ++this.childPass;
                break;
            }
            case FAIL: {
                ++this.childFail;
                break;
            }
            case FATAL: {
                ++this.childFatal;
                break;
            }
            case ERROR: {
                ++this.childError;
                break;
            }
            case WARNING: {
                ++this.childWarning;
                break;
            }
            case SKIP: {
                ++this.childSkip;
                break;
            }
            case INFO: {
                ++this.childInfo;
                break;
            }
        }
        if (status != Status.PASS && status != Status.INFO) {
            ++this.childExceptions;
        }
    }

    void incrementGrandChild(Status status) {
        switch (status) {
            case PASS: {
                ++this.grandChildPass;
                break;
            }
            case FAIL: {
                ++this.grandChildFail;
                break;
            }
            case FATAL: {
                ++this.grandChildFatal;
                break;
            }
            case ERROR: {
                ++this.grandChildError;
                break;
            }
            case WARNING: {
                ++this.grandChildWarning;
                break;
            }
            case SKIP: {
                ++this.grandChildSkip;
                break;
            }
            case INFO: {
                ++this.grandChildInfo;
                break;
            }
        }
        if (status != Status.PASS && status != Status.INFO) {
            ++this.grandChildExceptions;
        }
    }

    static enum ItemLevel {
        PARENT,
        CHILD,
        GRANDCHILD;

    }
}

