/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.TestAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TestAttributeTestContext<T extends TestAttribute>
implements Serializable {
    private static final long serialVersionUID = 2595632998970711190L;
    private T ta;
    private List<Test> testList;
    private int passed = 0;
    private int failed = 0;
    private int others = 0;

    public TestAttributeTestContext(T ta) {
        this.ta = ta;
    }

    public void setTest(Test test) {
        if (this.testList == null) {
            this.testList = new ArrayList<Test>();
        }
        this.passed += test.getStatus() == Status.PASS ? 1 : 0;
        this.failed += test.getStatus() == Status.FAIL || test.getStatus() == Status.FATAL ? 1 : 0;
        this.others += test.getStatus() != Status.PASS && test.getStatus() != Status.FAIL ? 1 : 0;
        this.testList.add(test);
    }

    public List<Test> getTestList() {
        return this.testList;
    }

    public String getName() {
        return ((TestAttribute)this.ta).getName();
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getOthers() {
        return this.others;
    }

    public T getAttribute() {
        return this.ta;
    }
}

