/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.InvalidFileException;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.configuration.Config;
import com.aventstack.extentreports.configuration.ConfigMap;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.reporter.BasicFileReporter;
import com.aventstack.extentreports.reporter.ReportAppendable;
import com.aventstack.extentreports.reporter.configuration.ExtentHtmlReporterConfiguration;
import com.aventstack.extentreports.reporter.converters.ExtentHtmlReporterConverter;
import com.aventstack.extentreports.viewdefs.Icon;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtentHtmlReporter
extends BasicFileReporter
implements ReportAppendable {
    private static final Logger logger = Logger.getLogger(ExtentHtmlReporter.class.getName());
    private static final String TEMPLATE_LOCATION = "view/html-report";
    private static final String TEMPLATE_NAME = "index.ftl";
    private static final String DEFAULT_CONFIG_FILE = "html-config.properties";
    private static String ENCODING = "UTF-8";
    private Boolean appendExisting = false;
    private List<Test> parsedTestCollection;
    private ExtentHtmlReporterConfiguration userConfig;

    ExtentHtmlReporter() {
        this.loadDefaultConfig();
    }

    public ExtentHtmlReporter(String filePath) {
        this();
        this.filePath = filePath;
        this.config().setFilePath(filePath);
    }

    public ExtentHtmlReporter(File file) {
        this(file.getAbsolutePath());
    }

    private void loadDefaultConfig() {
        this.configContext = new ConfigMap();
        this.userConfig = new ExtentHtmlReporterConfiguration();
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = loader.getResourceAsStream(DEFAULT_CONFIG_FILE);
        this.loadConfig(is);
    }

    public ExtentHtmlReporterConfiguration config() {
        return this.userConfig;
    }

    @Override
    public void start() {
        if (this.templateMap != null) {
            return;
        }
        this.templateMap = new HashMap();
        this.templateMap.put("report", this);
        this.templateMap.put("Icon", new Icon());
        BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_23);
        BeansWrapper beansWrapper = builder.build();
        try {
            TemplateHashModel fieldTypeModel = (TemplateHashModel)beansWrapper.getEnumModels().get(Status.class.getName());
            this.templateMap.put("Status", fieldTypeModel);
        }
        catch (TemplateModelException e) {
            logger.log(Level.SEVERE, "", e);
        }
        if (this.appendExisting.booleanValue() && this.filePath != null) {
            this.parseReportBuildTestCollection();
        }
    }

    private void parseReportBuildTestCollection() {
        File f = new File(this.filePath);
        if (!f.exists()) {
            return;
        }
        ExtentHtmlReporterConverter converter = new ExtentHtmlReporterConverter(this.filePath);
        this.parsedTestCollection = converter.parseAndGetModelCollection();
    }

    @Override
    public synchronized void flush() {
        if (this.testList == null || this.testList.size() == 0) {
            return;
        }
        try {
            this.loadUserConfig();
        }
        catch (InvalidFileException e) {
            logger.log(Level.SEVERE, "", e);
            return;
        }
        if (this.parsedTestCollection != null && this.parsedTestCollection.size() > 0) {
            for (int ix = 0; ix < this.parsedTestCollection.size(); ++ix) {
                this.testList.add(ix, this.parsedTestCollection.get(ix));
            }
        }
        this.parsedTestCollection = null;
        this.setEndTime(Calendar.getInstance().getTime());
        String extentSource = null;
        try {
            Template template = this.getConfig().getTemplate(TEMPLATE_NAME);
            StringWriter out = new StringWriter();
            template.process((Object)this.templateMap, (Writer)out);
            extentSource = out.toString();
            out.close();
        }
        catch (TemplateException | IOException e) {
            logger.log(Level.SEVERE, "Template not found", e);
        }
        com.aventstack.extentreports.utils.Writer.getInstance().write(new File(this.filePath), extentSource);
    }

    private void loadUserConfig() throws InvalidFileException {
        String filePath = (String)this.userConfig.getConfigMap().get("filePath");
        if (filePath == null && this.filePath == null) {
            throw new InvalidFileException("No file specified.");
        }
        this.userConfig.setFilePath(this.filePath);
        this.userConfig.getConfigMap().forEach((k, v) -> {
            if (v != null) {
                Config c = new Config();
                c.setKey((String)k);
                c.setValue(v);
                this.configContext.setConfig(c);
            }
        });
    }

    private Configuration getConfig() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        cfg.setClassForTemplateLoading(ExtentReports.class, TEMPLATE_LOCATION);
        cfg.setDefaultEncoding(ENCODING);
        return cfg;
    }

    @Override
    public void onScreenCaptureAdded(Test test, ScreenCapture screenCapture) throws IOException {
    }

    @Override
    public void setTestList(List<Test> reportTestList) {
        this.testList = reportTestList;
    }

    public List<Test> getTestList() {
        if (this.testList == null) {
            this.testList = new ArrayList();
        }
        return this.testList;
    }

    public boolean containsStatus(Status status) {
        boolean b = this.statusCollection == null || this.statusCollection.isEmpty() ? false : this.statusCollection.contains(status);
        return b;
    }

    public ConfigMap getConfigContext() {
        return this.configContext;
    }

    @Override
    public void setAppendExisting(Boolean b) {
        this.appendExisting = b;
    }
}

