/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ExceptionTestContextImpl;
import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.IReport;
import com.aventstack.extentreports.SessionStatusStats;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.SystemAttributeContext;
import com.aventstack.extentreports.TestAttributeTestContextProvider;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.SystemAttribute;
import com.aventstack.extentreports.model.Test;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

abstract class Report
implements IReport {
    protected boolean usesManualConfiguration = false;
    protected AnalysisStrategy strategy = AnalysisStrategy.TEST;
    private Date reportStartDate;
    private Date reportEndDate;
    private Status reportStatus = Status.PASS;
    private TestAttributeTestContextProvider<Category> categoryContext;
    private TestAttributeTestContextProvider<Author> authorContext;
    private ExceptionTestContextImpl exceptionContextBuilder;
    private SessionStatusStats stats;
    private SystemAttributeContext systemAttributeContext = new SystemAttributeContext();
    private List<ExtentReporter> reporterCollection;
    private List<String> testRunnerLogs;
    private List<Test> testCollection;

    protected Report() {
        this.stats = new SessionStatusStats(this.strategy);
        this.categoryContext = new TestAttributeTestContextProvider();
        this.authorContext = new TestAttributeTestContextProvider();
        this.exceptionContextBuilder = new ExceptionTestContextImpl();
        this.reportStartDate = Calendar.getInstance().getTime();
    }

    protected void attach(ExtentReporter reporter) {
        if (this.reporterCollection == null) {
            this.reporterCollection = new ArrayList<ExtentReporter>();
        }
        this.reporterCollection.add(reporter);
        reporter.start();
    }

    protected void detach(ExtentReporter reporter) {
        reporter.stop();
        this.reporterCollection.remove(reporter);
    }

    protected synchronized void createTest(Test test) {
        if (this.reporterCollection == null || this.reporterCollection.isEmpty()) {
            throw new IllegalStateException("No reporters were started. Atleast 1 reporter must be started to create tests.");
        }
        if (this.testCollection == null) {
            this.testCollection = new ArrayList<Test>();
        }
        this.testCollection.add(test);
        this.reporterCollection.forEach(x -> x.onTestStarted(test));
    }

    protected synchronized void removeTest(Test test) {
        List testList = this.testCollection.stream().filter(x -> x.getID() == test.getID()).collect(Collectors.toList());
        if (testList.size() == 1) {
            this.testCollection.remove(testList.get(0));
            return;
        }
        for (Test t : this.testCollection) {
            testList = t.getNodeContext().getAll().stream().filter(n -> n.getID() == test.getID()).collect(Collectors.toList());
            if (testList.size() != 1) continue;
            t.getNodeContext().getAll().remove(testList.get(0));
            return;
        }
    }

    synchronized void addNode(Test node) {
        this.reporterCollection.forEach(x -> x.onNodeStarted(node));
    }

    synchronized void addLog(Test test, Log log) {
        this.collectRunInfo();
        this.reporterCollection.forEach(x -> x.onLogAdded(test, log));
    }

    synchronized void assignCategory(Test test, Category category) {
        this.reporterCollection.forEach(x -> x.onCategoryAssigned(test, category));
    }

    synchronized void assignAuthor(Test test, Author author) {
        this.reporterCollection.forEach(x -> x.onAuthorAssigned(test, author));
    }

    synchronized void addScreenCapture(Test test, ScreenCapture sc) throws IOException {
        this.reporterCollection.forEach(x -> {
            try {
                x.onScreenCaptureAdded(test, sc);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    synchronized void addScreenCapture(Log log, ScreenCapture sc) throws IOException {
        this.reporterCollection.forEach(x -> {
            try {
                x.onScreenCaptureAdded(log, sc);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    synchronized void addScreencast(Test test, Screencast screencast) throws IOException {
        this.reporterCollection.forEach(x -> {
            try {
                x.onScreencastAdded(test, screencast);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    protected TestAttributeTestContextProvider<Author> getAuthorContextInfo() {
        return this.authorContext;
    }

    private void updateReportStatus(Status status) {
        int reportStatusIndex;
        int statusIndex = Status.getStatusHierarchy().indexOf(status);
        this.reportStatus = statusIndex < (reportStatusIndex = Status.getStatusHierarchy().indexOf(this.reportStatus)) ? status : this.reportStatus;
    }

    private void endTest(Test test) {
        test.end();
        this.updateReportStatus(test.getStatus());
    }

    protected synchronized void flush() {
        if (this.reporterCollection == null || this.reporterCollection.isEmpty()) {
            throw new IllegalStateException("No reporters were started. Atleast 1 reporter must be started to flush results.");
        }
        this.collectRunInfo();
        this.notifyReporters();
    }

    private synchronized void collectRunInfo() {
        if (this.testCollection == null || this.testCollection.isEmpty()) {
            return;
        }
        this.reportEndDate = Calendar.getInstance().getTime();
        this.testCollection.forEach(this::endTest);
        this.stats.refresh(this.testCollection);
        this.testCollection.forEach(test -> {
            if (test.hasCategory()) {
                test.getCategoryContext().getAll().forEach(x -> this.categoryContext.setAttributeContext((Category)x, (Test)test));
            }
            if (test.hasAuthor()) {
                test.getAuthorContext().getAll().forEach(x -> this.authorContext.setAttributeContext((Author)x, (Test)test));
            }
            if (test.hasException()) {
                test.getExceptionInfoList().forEach(x -> this.exceptionContextBuilder.setExceptionContext((ExceptionInfo)x, (Test)test));
            }
            if (test.hasChildren()) {
                test.getNodeContext().getAll().forEach(this::copyNodeAttributeAndRunTimeInfoToAttributeContexts);
            }
        });
        this.updateReportStartTimeForManualConfigurationSetting();
    }

    private void updateReportStartTimeForManualConfigurationSetting() {
        if (this.usesManualConfiguration) {
            this.testCollection.forEach(test -> {
                Date testStartDate = test.getStartTime();
                Date testEndDate = test.getEndTime();
                long testStartTime = testStartDate.getTime();
                long testEndTime = testEndDate.getTime();
                if (this.reportStartDate.getTime() > testStartTime) {
                    this.reportStartDate = testStartDate;
                }
                if (this.reportEndDate.getTime() > testEndTime) {
                    this.reportEndDate = testEndDate;
                }
            });
        }
    }

    private void copyNodeAttributeAndRunTimeInfoToAttributeContexts(Test node) {
        if (node.hasCategory()) {
            node.getCategoryContext().getAll().forEach(x -> this.categoryContext.setAttributeContext((Category)x, node));
        }
        if (node.hasAuthor()) {
            node.getAuthorContext().getAll().forEach(x -> this.authorContext.setAttributeContext((Author)x, node));
        }
        if (node.hasException()) {
            node.getExceptionInfoList().forEach(x -> this.exceptionContextBuilder.setExceptionContext((ExceptionInfo)x, node));
        }
        if (node.hasChildren()) {
            node.getNodeContext().getAll().forEach(this::copyNodeAttributeAndRunTimeInfoToAttributeContexts);
        }
    }

    private synchronized void notifyReporters() {
        this.reporterCollection.forEach(x -> {
            x.setTestList(this.testCollection);
            x.setCategoryContextInfo(this.categoryContext);
            x.setExceptionContextInfo(this.exceptionContextBuilder);
            x.setSystemAttributeContext(this.systemAttributeContext);
            x.setTestRunnerLogs(this.testRunnerLogs);
            x.setAnalysisStrategy(this.strategy);
            x.setStatusCount(this.stats);
            x.setStartTime(this.reportStartDate);
            x.setEndTime(this.reportEndDate);
        });
        this.reporterCollection.forEach(ExtentReporter::flush);
    }

    protected void end() {
        this.flush();
        this.reporterCollection.forEach(ExtentReporter::stop);
        this.reporterCollection.clear();
    }

    protected void setSystemInfo(SystemAttribute sa) {
        this.systemAttributeContext.setSystemAttribute(sa);
    }

    protected void setTestRunnerLogs(String log) {
        if (this.testRunnerLogs == null) {
            this.testRunnerLogs = new ArrayList<String>();
        }
        this.testRunnerLogs.add(log);
    }

    protected void setAnalysisStrategy(AnalysisStrategy strategy) {
        this.strategy = strategy;
        this.stats = new SessionStatusStats(strategy);
    }
}

