/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public enum Status implements Serializable
{
    PASS,
    FAIL,
    FATAL,
    ERROR,
    WARNING,
    INFO,
    DEBUG,
    SKIP;

    private static List<Status> statusHierarchy;

    public static List<Status> getStatusHierarchy() {
        return statusHierarchy;
    }

    static void setStatusHierarchy(List<Status> statusHierarchy) {
        Status.statusHierarchy = statusHierarchy;
    }

    static void resetStatusHierarchy() {
        List<Status> statusHierarchy = Arrays.asList(FATAL, FAIL, ERROR, WARNING, SKIP, PASS, INFO);
        Status.setStatusHierarchy(statusHierarchy);
    }

    public String toString() {
        switch (this) {
            case PASS: {
                return "pass";
            }
            case FAIL: {
                return "fail";
            }
            case FATAL: {
                return "fatal";
            }
            case ERROR: {
                return "error";
            }
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case DEBUG: {
                return "debug";
            }
            case SKIP: {
                return "skip";
            }
        }
        return "unknown";
    }

    static {
        statusHierarchy = Arrays.asList(FATAL, FAIL, ERROR, WARNING, SKIP, PASS, DEBUG, INFO);
    }
}

