/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.configuration.Config;
import com.aventstack.extentreports.configuration.ConfigMap;
import com.aventstack.extentreports.mediastorage.MediaStorage;
import com.aventstack.extentreports.mediastorage.MediaStorageManagerFactory;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.BasicReportElement;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.SystemAttribute;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.ReportAppendable;
import com.aventstack.extentreports.reporter.configuration.ExtentXReporterConfiguration;
import com.aventstack.extentreports.utils.MongoUtil;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class ExtentXReporter
extends AbstractReporter
implements ReportAppendable {
    private static final String DEFAULT_CONFIG_FILE = "extentx-config.properties";
    private static final String DEFAULT_PROJECT_NAME = "Default";
    private Boolean appendExisting;
    private String url;
    private Map<String, ObjectId> categoryNameObjectIdCollection;
    private Map<String, ObjectId> exceptionNameObjectIdCollection;
    private ObjectId reportId;
    private ObjectId projectId;
    private MongoClient mongoClient;
    private MongoDatabase db;
    private MongoCollection<Document> projectCollection;
    private MongoCollection<Document> reportCollection;
    private MongoCollection<Document> testCollection;
    private MongoCollection<Document> logCollection;
    private MongoCollection<Document> exceptionCollection;
    private MongoCollection<Document> mediaCollection;
    private MongoCollection<Document> categoryCollection;
    private MongoCollection<Document> authorCollection;
    private MongoCollection<Document> categoryTestsTestCategories;
    private MongoCollection<Document> authorTestsTestAuthors;
    private MongoCollection<Document> environmentCollection;
    private MediaStorage media;
    private ExtentXReporterConfiguration userConfig;

    ExtentXReporter() {
        this.loadDefaultConfig();
    }

    public ExtentXReporter(String host) {
        this();
        this.mongoClient = new MongoClient(host, 27017);
    }

    public ExtentXReporter(String host, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(host, options);
    }

    public ExtentXReporter(String host, int port) {
        this();
        this.mongoClient = new MongoClient(host, port);
    }

    public ExtentXReporter(MongoClientURI uri) {
        this();
        this.mongoClient = new MongoClient(uri);
    }

    public ExtentXReporter(ServerAddress addr) {
        this();
        this.mongoClient = new MongoClient(addr);
    }

    public ExtentXReporter(List<ServerAddress> seeds) {
        this();
        this.mongoClient = new MongoClient(seeds);
    }

    public ExtentXReporter(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this();
        this.mongoClient = new MongoClient(seeds, credentialsList);
    }

    public ExtentXReporter(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(seeds, credentialsList, options);
    }

    public ExtentXReporter(List<ServerAddress> seeds, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(seeds, options);
    }

    public ExtentXReporter(ServerAddress addr, List<MongoCredential> credentialsList) {
        this();
        this.mongoClient = new MongoClient(addr, credentialsList);
    }

    public ExtentXReporter(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(addr, credentialsList, options);
    }

    public ExtentXReporter(ServerAddress addr, MongoClientOptions options) {
        this();
        this.mongoClient = new MongoClient(addr, options);
    }

    public ExtentXReporterConfiguration config() {
        return this.userConfig;
    }

    @Override
    public void start() {
        this.loadUserConfig();
        this.db = this.mongoClient.getDatabase("extent");
        this.projectCollection = this.db.getCollection("project");
        this.reportCollection = this.db.getCollection("report");
        this.testCollection = this.db.getCollection("test");
        this.logCollection = this.db.getCollection("log");
        this.exceptionCollection = this.db.getCollection("exception");
        this.mediaCollection = this.db.getCollection("media");
        this.categoryCollection = this.db.getCollection("category");
        this.authorCollection = this.db.getCollection("author");
        this.environmentCollection = this.db.getCollection("environment");
        this.categoryTestsTestCategories = this.db.getCollection("category_tests__test_categories");
        this.authorTestsTestAuthors = this.db.getCollection("author_tests__test_authors");
        this.setupProject();
    }

    private void loadDefaultConfig() {
        this.configContext = new ConfigMap();
        this.userConfig = new ExtentXReporterConfiguration();
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = loader.getResourceAsStream(DEFAULT_CONFIG_FILE);
        this.loadConfig(is);
    }

    private void loadUserConfig() {
        this.userConfig.getConfigMap().forEach((k, v) -> {
            if (v != null) {
                Config c = new Config();
                c.setKey((String)k);
                c.setValue(v);
                this.configContext.setConfig(c);
            }
        });
    }

    private void setupProject() {
        Document doc;
        Document project;
        String projectName = this.configContext.getValue("projectName").toString().trim();
        if (projectName == null || projectName.isEmpty()) {
            projectName = DEFAULT_PROJECT_NAME;
        }
        if ((project = (Document)this.projectCollection.find((Bson)(doc = new Document("name", (Object)projectName))).first()) != null) {
            this.projectId = project.getObjectId((Object)"_id");
        } else {
            this.projectCollection.insertOne((Object)doc);
            this.projectId = MongoUtil.getId(doc);
        }
        this.setupReport(projectName);
    }

    private void setupReport(String projectName) {
        FindIterable iterable;
        Document report;
        Object id;
        String reportName = this.configContext.getValue("reportName").toString().trim();
        if (reportName == null || reportName.isEmpty()) {
            reportName = projectName + " - " + Calendar.getInstance().getTimeInMillis();
        }
        if ((id = this.configContext.getValue("reportId")) != null && !id.toString().isEmpty() && this.appendExisting.booleanValue() && (report = (Document)(iterable = this.reportCollection.find((Bson)new Document("_id", (Object)new ObjectId(id.toString())))).first()) != null) {
            this.reportId = report.getObjectId((Object)"_id");
            return;
        }
        Document doc = new Document("name", (Object)reportName).append("startTime", (Object)this.getStartTime()).append("project", (Object)this.projectId);
        this.reportCollection.insertOne((Object)doc);
        this.reportId = MongoUtil.getId(doc);
    }

    @Override
    public void stop() {
        this.mongoClient.close();
    }

    @Override
    public synchronized void flush() {
        this.setEndTime(Calendar.getInstance().getTime());
        if (this.testList == null || this.testList.size() == 0) {
            return;
        }
        Document doc = new Document("endTime", (Object)this.getEndTime()).append("duration", (Object)this.getRunDuration()).append("parentLength", (Object)this.sc.getParentCount()).append("passParentLength", (Object)this.sc.getParentCountPass()).append("failParentLength", (Object)this.sc.getParentCountFail()).append("fatalParentLength", (Object)this.sc.getParentCountFatal()).append("errorParentLength", (Object)this.sc.getParentCountError()).append("warningParentLength", (Object)this.sc.getParentCountWarning()).append("skipParentLength", (Object)this.sc.getParentCountSkip()).append("exceptionsParentLength", (Object)this.sc.getChildCountExceptions()).append("childLength", (Object)this.sc.getChildCount()).append("passChildLength", (Object)this.sc.getChildCountPass()).append("failChildLength", (Object)this.sc.getChildCountFail()).append("fatalChildLength", (Object)this.sc.getChildCountFatal()).append("errorChildLength", (Object)this.sc.getChildCountError()).append("warningChildLength", (Object)this.sc.getChildCountWarning()).append("skipChildLength", (Object)this.sc.getChildCountSkip()).append("infoChildLength", (Object)this.sc.getChildCountInfo()).append("exceptionsChildLength", (Object)this.sc.getChildCountExceptions()).append("grandChildLength", (Object)this.sc.getGrandChildCount()).append("passGrandChildLength", (Object)this.sc.getGrandChildCountPass()).append("failGrandChildLength", (Object)this.sc.getGrandChildCountFail()).append("fatalGrandChildLength", (Object)this.sc.getGrandChildCountFatal()).append("errorGrandChildLength", (Object)this.sc.getGrandChildCountError()).append("warningGrandChildLength", (Object)this.sc.getGrandChildCountWarning()).append("skipGrandChildLength", (Object)this.sc.getGrandChildCountSkip()).append("exceptionsGrandChildLength", (Object)this.sc.getGrandChildCountExceptions());
        this.reportCollection.updateOne((Bson)new Document("_id", (Object)this.reportId), (Bson)new Document("$set", (Object)doc));
        this.insertUpdateSystemAttribute();
    }

    private void insertUpdateSystemAttribute() {
        List<SystemAttribute> systemAttrList = this.getSystemAttributeContext().getSystemAttributeList();
        for (SystemAttribute sysAttr : systemAttrList) {
            Document doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)sysAttr.getName());
            Document envSingle = (Document)this.environmentCollection.find((Bson)doc).first();
            if (envSingle == null) {
                doc.append("value", (Object)sysAttr.getValue());
                this.environmentCollection.insertOne((Object)doc);
                continue;
            }
            ObjectId id = envSingle.getObjectId((Object)"_id");
            doc = new Document("_id", (Object)id).append("value", (Object)sysAttr.getValue());
            this.environmentCollection.updateOne((Bson)new Document("_id", (Object)id), (Bson)new Document("$set", (Object)doc));
        }
    }

    @Override
    public void onTestStarted(Test test) {
        Document doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("level", (Object)test.getLevel()).append("name", (Object)test.getName()).append("status", (Object)test.getStatus().toString()).append("description", (Object)test.getDescription()).append("startTime", (Object)test.getStartTime()).append("endTime", (Object)test.getEndTime()).append("bdd", (Object)test.isBehaviorDrivenType()).append("childNodesLength", (Object)test.getNodeContext().size());
        if (test.isBehaviorDrivenType()) {
            doc.append("bddType", (Object)test.getBehaviorDrivenType().getSimpleName());
        }
        this.testCollection.insertOne((Object)doc);
        ObjectId testId = MongoUtil.getId(doc);
        test.setObjectId(testId);
    }

    @Override
    public synchronized void onNodeStarted(Test node) {
        Document doc = new Document("parent", (Object)node.getParent().getObjectId()).append("parentName", (Object)node.getParent().getName()).append("project", (Object)this.projectId).append("report", (Object)this.reportId).append("level", (Object)node.getLevel()).append("name", (Object)node.getName()).append("status", (Object)node.getStatus().toString()).append("description", (Object)node.getDescription()).append("startTime", (Object)node.getStartTime()).append("endTime", (Object)node.getEndTime()).append("childNodesCount", (Object)node.getNodeContext().getAll().size()).append("bdd", (Object)node.isBehaviorDrivenType()).append("childNodesLength", (Object)node.getNodeContext().size());
        if (node.isBehaviorDrivenType()) {
            doc.append("bddType", (Object)node.getBehaviorDrivenType().getSimpleName());
        }
        this.testCollection.insertOne((Object)doc);
        ObjectId nodeId = MongoUtil.getId(doc);
        node.setObjectId(nodeId);
        this.updateTestBasedOnNode(node.getParent());
    }

    private void updateTestBasedOnNode(Test test) {
        Document doc = new Document("childNodesLength", (Object)test.getNodeContext().size());
        this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
    }

    @Override
    public synchronized void onLogAdded(Test test, Log log) {
        Document doc = new Document("test", (Object)test.getObjectId()).append("project", (Object)this.projectId).append("report", (Object)this.reportId).append("testName", (Object)test.getName()).append("sequence", (Object)log.getSequence()).append("status", (Object)log.getStatus().toString()).append("timestamp", (Object)log.getTimestamp()).append("details", (Object)log.getDetails());
        this.logCollection.insertOne((Object)doc);
        ObjectId logId = MongoUtil.getId(doc);
        log.setObjectId(logId);
        if (test.hasException()) {
            if (this.exceptionNameObjectIdCollection == null) {
                this.exceptionNameObjectIdCollection = new HashMap<String, ObjectId>();
            }
            ExceptionInfo ex = test.getExceptionInfoList().get(0);
            doc = new Document("report", (Object)this.reportId).append("project", (Object)this.projectId).append("name", (Object)ex.getExceptionName());
            FindIterable iterable = this.exceptionCollection.find((Bson)doc);
            Document docException = (Document)iterable.first();
            if (!this.exceptionNameObjectIdCollection.containsKey(ex.getExceptionName())) {
                if (docException != null) {
                    this.exceptionNameObjectIdCollection.put(ex.getExceptionName(), docException.getObjectId((Object)"_id"));
                } else {
                    doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)ex.getExceptionName()).append("stacktrace", (Object)ex.getStackTrace()).append("testCount", (Object)0);
                    this.exceptionCollection.insertOne((Object)doc);
                    ObjectId exceptionId = MongoUtil.getId(doc);
                    docException = (Document)this.exceptionCollection.find((Bson)new Document("_id", (Object)exceptionId)).first();
                    this.exceptionNameObjectIdCollection.put(ex.getExceptionName(), exceptionId);
                }
            }
            Integer testCount = (Integer)docException.get((Object)"testCount") + 1;
            doc = new Document("testCount", (Object)testCount);
            this.exceptionCollection.updateOne((Bson)new Document("_id", (Object)docException.getObjectId((Object)"_id")), (Bson)new Document("$set", (Object)doc));
            doc = new Document("exception", (Object)this.exceptionNameObjectIdCollection.get(ex.getExceptionName()));
            this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
        }
        this.endTestRecursive(test);
    }

    private void endTestRecursive(Test test) {
        Document doc = new Document("status", (Object)test.getStatus().toString()).append("endTime", (Object)test.getEndTime()).append("duration", (Object)test.getRunDurationMillis()).append("categorized", (Object)test.hasCategory());
        this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
        if (test.getLevel() > 0) {
            this.endTestRecursive(test.getParent());
        }
    }

    @Override
    public void onCategoryAssigned(Test test, Category category) {
        Document doc;
        if (this.categoryNameObjectIdCollection == null) {
            this.categoryNameObjectIdCollection = new HashMap<String, ObjectId>();
        }
        if (!this.categoryNameObjectIdCollection.containsKey(category.getName())) {
            doc = new Document("report", (Object)this.reportId).append("project", (Object)this.projectId).append("name", (Object)category.getName());
            FindIterable iterable = this.categoryCollection.find((Bson)doc);
            Document docCategory = (Document)iterable.first();
            if (docCategory != null) {
                this.categoryNameObjectIdCollection.put(category.getName(), docCategory.getObjectId((Object)"_id"));
            } else {
                doc = new Document("tests", (Object)test.getObjectId()).append("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)category.getName()).append("status", (Object)test.getStatus().toString()).append("testName", (Object)test.getName());
                this.categoryCollection.insertOne((Object)doc);
                ObjectId categoryId = MongoUtil.getId(doc);
                this.categoryNameObjectIdCollection.put(category.getName(), categoryId);
            }
        }
        doc = new Document("test_categories", (Object)test.getObjectId()).append("category_tests", (Object)this.categoryNameObjectIdCollection.get(category.getName())).append("category", (Object)category.getName()).append("test", (Object)test.getName());
        this.categoryTestsTestCategories.insertOne((Object)doc);
    }

    @Override
    public void onAuthorAssigned(Test test, Author author) {
        Document doc = new Document("tests", (Object)test.getObjectId()).append("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)author.getName()).append("status", (Object)test.getStatus().toString()).append("testName", (Object)test.getName());
        this.authorCollection.insertOne((Object)doc);
        ObjectId authorId = MongoUtil.getId(doc);
        doc = new Document("test_authors", (Object)test.getObjectId()).append("author_tests", (Object)authorId).append("author", (Object)author.getName()).append("test", (Object)test.getName());
        this.authorTestsTestAuthors.insertOne((Object)doc);
    }

    @Override
    public void onScreenCaptureAdded(Test test, ScreenCapture screenCapture) throws IOException {
        this.initOnScreenCaptureAdded(screenCapture);
        this.createMedia(test, screenCapture);
        this.storeMedia(screenCapture);
    }

    @Override
    public void onScreenCaptureAdded(Log log, ScreenCapture screenCapture) throws IOException {
        screenCapture.setLogObjectId(log.getObjectId());
        this.initOnScreenCaptureAdded(screenCapture);
        this.createMedia(log, screenCapture);
        this.storeMedia(screenCapture);
    }

    private void storeMedia(ScreenCapture screenCapture) throws IOException {
        this.media.storeMedia(screenCapture);
    }

    private void initOnScreenCaptureAdded(ScreenCapture screenCapture) throws IOException {
        this.storeUrl();
        screenCapture.setReportObjectId(this.reportId);
        this.initMedia();
    }

    private void storeUrl() throws IOException {
        if (this.url == null) {
            Object url = this.configContext.getValue("serverUrl");
            if (url == null) {
                throw new IOException("server url cannot be null, use extentx.config().setServerUrl(url)");
            }
            this.url = url.toString().trim();
        }
    }

    private void createMedia(BasicReportElement el, Media media) {
        Document doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("sequence", (Object)media.getSequence()).append("mediaType", (Object)media.getMediaType().toString().toLowerCase());
        if (el.getClass() == Test.class) {
            doc.append("test", (Object)el.getObjectId()).append("testName", (Object)((Test)el).getName());
        } else {
            doc.append("log", (Object)el.getObjectId());
        }
        this.mediaCollection.insertOne((Object)doc);
        ObjectId mediaId = MongoUtil.getId(doc);
        media.setObjectId(mediaId);
    }

    private void initMedia() throws IOException {
        if (this.media == null) {
            this.media = new MediaStorageManagerFactory().getManager("http");
            this.media.init(this.url);
        }
    }

    @Override
    public void onScreencastAdded(Test test, Screencast screencast) throws IOException {
        this.storeUrl();
        screencast.setReportObjectId(this.reportId);
        this.createMedia(test, screencast);
        this.initMedia();
        this.media.storeMedia(screencast);
    }

    @Override
    public void setTestList(List<Test> reportTestList) {
        this.testList = reportTestList;
    }

    public List<Test> getTestList() {
        if (this.testList == null) {
            this.testList = new ArrayList();
        }
        return this.testList;
    }

    @Override
    public void setAppendExisting(Boolean b) {
        this.appendExisting = b;
    }

    static {
        Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
        mongoLogger.setLevel(Level.SEVERE);
    }
}

