/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.gherkin.GherkinDialect;
import com.aventstack.extentreports.gherkin.GherkinDialectProvider;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import freemarker.template.utility.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GherkinKeyword {
    private static final Logger logger = Logger.getLogger(GherkinKeyword.class.getName());
    private Class<IGherkinFormatterModel> clazz = IGherkinFormatterModel.class;
    private IGherkinFormatterModel keywordClazz;

    public GherkinKeyword(String keyword) throws ClassNotFoundException {
        GherkinDialect dialect = null;
        String apiKeyword = StringUtil.capitalize((String)keyword.trim());
        String refPath = this.clazz.getPackage().getName();
        try {
            dialect = GherkinDialectProvider.getDialect();
            if (dialect != null && !dialect.getLanguage().equalsIgnoreCase(GherkinDialectProvider.getDefaultLanguage())) {
                apiKeyword = null;
                Map<String, List<String>> keywords = dialect.getKeywords();
                for (Map.Entry<String, List<String>> key : keywords.entrySet()) {
                    boolean b = key.getValue().stream().anyMatch(x -> x.trim().equalsIgnoreCase(keyword.trim()));
                    if (!b) continue;
                    apiKeyword = StringUtil.capitalize((String)key.getKey());
                    break;
                }
            }
            Class<?> c = Class.forName(refPath + "." + apiKeyword.replace(" ", ""));
            this.keywordClazz = (IGherkinFormatterModel)c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    IGherkinFormatterModel getKeyword() {
        return this.keywordClazz;
    }
}

