/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.converters;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.TestAttribute;
import com.aventstack.extentreports.reporter.converters.ExtentHtmlBddNodesConverter;
import com.aventstack.extentreports.reporter.converters.ExtentHtmlLogConverter;
import com.aventstack.extentreports.reporter.converters.ExtentHtmlNodeConverter;
import com.aventstack.extentreports.utils.DateUtil;
import com.aventstack.extentreports.utils.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class ExtentHtmlTestConverter {
    private static final Logger logger = Logger.getLogger(ExtentHtmlTestConverter.class.getName());
    private Document doc;
    private TestParserUtils parserUtils;
    private String docTimeStampFormat;

    public ExtentHtmlTestConverter(String filePath) {
        String html = Reader.readAllText(filePath);
        this.doc = Jsoup.parse((String)html);
        Element meta = this.doc.select("meta[http-equiv=content-type], meta[charset]").first();
        if (meta != null) {
            String foundCharset = null;
            if (meta.hasAttr("http-equiv")) {
                foundCharset = meta.attr("content");
            }
            if (foundCharset == null && meta.hasAttr("charset")) {
                try {
                    if (Charset.isSupported(meta.attr("charset"))) {
                        foundCharset = meta.attr("charset");
                    }
                }
                catch (IllegalCharsetNameException e) {
                    foundCharset = null;
                }
            }
            foundCharset = foundCharset == null ? "utf-8" : foundCharset;
            this.doc = Jsoup.parse((String)html, (String)foundCharset);
        }
        this.docTimeStampFormat = this.doc.getElementById("timeStampFormat").attr("content");
        this.parserUtils = new TestParserUtils();
    }

    public List<Test> parseAndGetTests() {
        Elements allTests = this.doc.select("#test-collection > .test");
        if (allTests.size() == 0) {
            return null;
        }
        ArrayList<Test> modelTestList = new ArrayList<Test>();
        for (Element testElement : allTests) {
            Test test = this.parseAndGetTest(testElement);
            modelTestList.add(test);
        }
        return modelTestList;
    }

    private Test parseAndGetTest(Element testElement) {
        Test test = new Test();
        test.setUseManualConfiguration(true);
        test.setLevel(0);
        String name = this.parserUtils.getName(testElement);
        test.setName(name);
        String description = this.parserUtils.getDescription(testElement);
        test.setDescription(description);
        Date startTime = this.parserUtils.getStartTime(testElement);
        test.setStartTime(startTime);
        Date endTime = this.parserUtils.getEndTime(testElement);
        test.setEndTime(endTime);
        if (!this.doc.select("body").first().hasClass("bdd-report")) {
            this.buildStandardTestDeps(testElement, test);
        } else {
            this.buildBddTestsDeps(testElement, test);
        }
        test.end();
        Status status = this.parserUtils.getStatus(testElement);
        if (test.getStatus() != status) {
            logger.log(Level.WARNING, "Woops.  Looks like something went wrong parsing your existing report.");
            logger.log(Level.WARNING, "The current test status for " + name + ": " + status + " does not match the calculated status: " + test.getStatus());
            logger.log(Level.WARNING, "Forcefully setting the status to: " + status);
            test.setStatus(status);
        }
        return test;
    }

    private void buildStandardTestDeps(Element testElement, Test test) {
        List<ScreenCapture> list;
        List<TestAttribute> authorCollection;
        List<TestAttribute> categoryCollection = this.parserUtils.getAttributes(Category.class, testElement);
        if (categoryCollection != null && !categoryCollection.isEmpty()) {
            for (TestAttribute testAttribute : categoryCollection) {
                test.setCategory(testAttribute);
            }
        }
        if ((authorCollection = this.parserUtils.getAttributes(Author.class, testElement)) != null && !authorCollection.isEmpty()) {
            for (TestAttribute testAttribute : authorCollection) {
                test.setAuthor(testAttribute);
            }
        }
        if ((list = this.parserUtils.getMediaElements(testElement)) != null && !list.isEmpty()) {
            for (Media media : list) {
                test.setScreenCapture((ScreenCapture)media);
            }
        }
        ExtentHtmlLogConverter extentHtmlLogConverter = new ExtentHtmlLogConverter(test, testElement);
        extentHtmlLogConverter.parseAndAddLogsToTest();
        ExtentHtmlNodeConverter extentHtmlNodeConverter = new ExtentHtmlNodeConverter(test, testElement, 1, this.docTimeStampFormat);
        extentHtmlNodeConverter.parseAndAddNodes();
    }

    private void buildBddTestsDeps(Element testElement, Test test) {
        ExtentHtmlBddNodesConverter nodeConverter = new ExtentHtmlBddNodesConverter(test, testElement);
        nodeConverter.parseAndAddNodes();
    }

    class TestParserUtils {
        TestParserUtils() {
        }

        public String getName(Element test) {
            return test.select(".test-name").first().html();
        }

        public Status getStatus(Element test) {
            String status = test.attr("status").toUpperCase();
            return Status.valueOf(status);
        }

        public String getDescription(Element test) {
            Elements testDesc = test.select(".test-desc");
            if (!testDesc.isEmpty()) {
                return testDesc.first().html();
            }
            return null;
        }

        public Date getStartTime(Element test) {
            Element startTime = test.select(".start-time").first();
            if (startTime != null) {
                return DateUtil.parse(startTime.text(), ExtentHtmlTestConverter.this.docTimeStampFormat);
            }
            return Calendar.getInstance().getTime();
        }

        public Date getEndTime(Element test) {
            Element endTime = test.select(".end-time").first();
            if (endTime != null) {
                return DateUtil.parse(endTime.text(), ExtentHtmlTestConverter.this.docTimeStampFormat);
            }
            return Calendar.getInstance().getTime();
        }

        public List<ScreenCapture> getMediaElements(Element test) {
            String selector = ":root > .test-content > .screenshots img";
            Elements elements = test.select(selector);
            ArrayList<ScreenCapture> scList = null;
            ScreenCapture sc = null;
            if (!elements.isEmpty()) {
                scList = new ArrayList<ScreenCapture>();
                for (Element element : elements) {
                    String src = element.attr("data-src");
                    sc = new ScreenCapture();
                    sc.setPath(src);
                    scList.add(sc);
                }
            }
            return scList;
        }

        public List<TestAttribute> getAttributes(Class clazz, Element test) {
            ArrayList<TestAttribute> attrCollection = null;
            String selector = clazz == Category.class ? ":root > .test-content > .test-attributes > .category-list > .category" : ":root > .test-content > .test-attributes > .author-list > .author";
            Elements elements = test.select(selector);
            if (!elements.isEmpty()) {
                attrCollection = new ArrayList<TestAttribute>();
                for (Element element : elements) {
                    String attrName = element.text();
                    try {
                        TestAttribute attr = (TestAttribute)clazz.getDeclaredConstructor(String.class).newInstance(attrName);
                        attrCollection.add(attr);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
            return attrCollection;
        }
    }
}

