/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.configuration;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.ExtentLoggerReporter;
import com.aventstack.extentreports.reporter.configuration.BasicFileConfiguration;
import com.aventstack.extentreports.reporter.configuration.IReporterConfiguration;
import com.aventstack.extentreports.reporter.configuration.Protocol;
import com.aventstack.extentreports.reporter.configuration.Theme;
import com.aventstack.extentreports.resource.OfflineResxDelegate;
import com.aventstack.extentreports.utils.FileUtil;
import java.io.File;
import java.util.stream.Stream;

public class ExtentLoggerFormatterConfiguration
extends BasicFileConfiguration
implements IReporterConfiguration {
    private Protocol protocol;
    private Theme theme;

    public ExtentLoggerFormatterConfiguration(AbstractReporter reporter) {
        super(reporter);
    }

    public void setProtocol(Protocol protocol) {
        this.usedConfigs.put("protocol", String.valueOf((Object)protocol).toLowerCase());
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setTheme(Theme theme) {
        this.usedConfigs.put("theme", String.valueOf((Object)theme).toLowerCase());
        this.theme = theme;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setAutoCreateRelativePathMedia(boolean v) {
        this.usedConfigs.put("autoCreateRelativePathMedia", String.valueOf(v));
    }

    public void enableOfflineMode(Boolean offline) {
        this.usedConfigs.put("enableOfflineMode", String.valueOf(offline));
        this.usedConfigs.put("offlineDirectory", this.getReporter().getReporterName() + "/");
        if (offline.booleanValue()) {
            File f = this.getTargetDirectory(((ExtentLoggerReporter)this.getReporter()).getFileFile());
            String s = "/";
            String resourcePackagePath = ExtentReports.class.getPackage().getName().replace(".", s);
            resourcePackagePath = resourcePackagePath + s + "offline" + s;
            String[] resx = this.combine(this.getJSFiles(), this.getCSSFiles(), this.getIconFiles(), this.getImgFiles());
            OfflineResxDelegate.saveOfflineResources(resourcePackagePath, resx, f.getAbsolutePath());
        }
    }

    private File getTargetDirectory(File f) {
        String dir;
        if (FileUtil.isDirectory(f).booleanValue()) {
            dir = f.getAbsolutePath().replace("\\", "/");
        } else {
            dir = f.getAbsolutePath().replace("\\", "/");
            dir = new File(dir).getParent();
        }
        dir = dir + "/" + this.getReporter().getReporterName();
        return new File(dir);
    }

    private String[] combine(String[] ... array) {
        String[] result = new String[]{};
        for (String[] arr : array) {
            result = (String[])Stream.of(result, arr).flatMap(Stream::of).toArray(String[]::new);
        }
        return result;
    }

    private String[] getJSFiles() {
        String commonsPath = "commons/js/";
        String reporterPath = this.getReporter().getReporterName() + "/js/";
        String[] files = new String[]{commonsPath + "attr.js", commonsPath + "dashboard.js", reporterPath + "logger-scripts.js"};
        return files;
    }

    private String[] getCSSFiles() {
        String stylesPath = "css/";
        String reporterPath = this.getReporter().getReporterName() + "/" + stylesPath + "/";
        String[] files = new String[]{reporterPath + "logger-style.css"};
        return files;
    }

    private String[] getIconFiles() {
        String path = "commons/css/icons/";
        String iconDirPath = "fontawesome/";
        String[] files = new String[]{path + "font-awesome.min.css", path + iconDirPath + "fontawesome-webfont.eot", path + iconDirPath + "fontawesome-webfont.svg", path + iconDirPath + "fontawesome-webfont.ttf", path + iconDirPath + "fontawesome-webfont.woff", path + iconDirPath + "fontawesome-webfont.woff2", path + iconDirPath + "FontAwesome.otf"};
        return files;
    }

    private String[] getImgFiles() {
        String path = "commons/img/";
        String[] files = new String[]{path + "logo.png"};
        return files;
    }
}

