/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ExceptionTestContextImpl;
import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.ReportAggregatesBuilder;
import com.aventstack.extentreports.ReportService;
import com.aventstack.extentreports.ReportStatusStats;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.SystemAttributeContext;
import com.aventstack.extentreports.TestAttributeTestContextProvider;
import com.aventstack.extentreports.TestRemover;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.SystemAttribute;
import com.aventstack.extentreports.model.Test;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

abstract class ExtentObservable
implements ReportService {
    private AnalysisStrategy strategy = AnalysisStrategy.TEST;
    private boolean usesManualConfiguration = false;
    private Status reportStatus = Status.PASS;
    private Date reportStartDate = Calendar.getInstance().getTime();
    private Date reportEndDate;
    private TestAttributeTestContextProvider<Category> categoryContext = new TestAttributeTestContextProvider();
    private TestAttributeTestContextProvider<Author> authorContext = new TestAttributeTestContextProvider();
    private TestAttributeTestContextProvider<Device> deviceContext = new TestAttributeTestContextProvider();
    private ExceptionTestContextImpl exceptionContextBuilder = new ExceptionTestContextImpl();
    private SystemAttributeContext systemAttributeContext = new SystemAttributeContext();
    private List<ExtentReporter> reporterList = new ArrayList<ExtentReporter>();
    private List<String> testRunnerLogs = new ArrayList<String>();
    private List<Test> testList = new ArrayList<Test>();
    private ReportStatusStats stats = new ReportStatusStats(this.strategy);
    private List<Status> statusList = new ArrayList<Status>();
    private Map<Status, Boolean> statusMap = new HashMap<Status, Boolean>();

    protected ExtentObservable() {
    }

    protected void register(ExtentReporter reporter) {
        this.reporterList.add(reporter);
        reporter.start();
    }

    protected void deregister(ExtentReporter reporter) {
        reporter.stop();
        this.reporterList.remove(reporter);
    }

    protected List<ExtentReporter> getReporterCollection() {
        return this.reporterList;
    }

    protected synchronized void saveTest(Test test) {
        this.reporterInitialized();
        this.testList.add(test);
        this.reporterList.forEach(x -> x.onTestStarted(test));
    }

    private void reporterInitialized() {
    }

    protected synchronized void removeTest(Test test) {
        this.removeTestTestList(test);
        this.removeTestTestAttributeContext(test);
        this.reporterList.forEach(x -> x.onTestRemoved(test));
    }

    private void removeTestTestList(Test test) {
        TestRemover.remove(this.testList, test);
        this.refreshReportEntities();
    }

    private void removeTestTestAttributeContext(Test test) {
        if (test.hasCategory()) {
            this.categoryContext.removeTest(test);
        }
        if (test.hasAuthor()) {
            this.authorContext.removeTest(test);
        }
        if (test.hasDevice()) {
            this.deviceContext.removeTest(test);
        }
    }

    private void refreshReportEntities() {
        this.refreshReportStats();
        this.refreshStatusList();
    }

    private void refreshReportStats() {
        this.stats.refresh(this.testList);
    }

    private void refreshStatusList() {
        this.statusMap.clear();
        this.statusList.clear();
        this.refreshStatusList(this.testList);
        this.statusMap.forEach((k, v) -> this.statusList.add((Status)k));
    }

    private void refreshStatusList(List<Test> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        list.stream().map(Test::getStatus).distinct().collect(Collectors.toList()).forEach(x -> this.statusMap.put((Status)x, false));
        list.forEach(x -> this.refreshStatusList(x.getNodeContext().getAll()));
    }

    synchronized void addNode(Test node) {
        this.reporterList.forEach(x -> x.onNodeStarted(node));
    }

    synchronized void addLog(Test test, Log log) {
        this.collectRunInfo();
        this.reporterList.forEach(x -> x.onLogAdded(test, log));
    }

    synchronized void assignCategory(Test test, Category category) {
        this.reporterList.forEach(x -> x.onCategoryAssigned(test, category));
    }

    synchronized void assignAuthor(Test test, Author author) {
        this.reporterList.forEach(x -> x.onAuthorAssigned(test, author));
    }

    synchronized void assignDevice(Test test, Device device) {
        this.reporterList.forEach(x -> x.onDeviceAssigned(test, device));
    }

    synchronized void addScreenCapture(Test test, ScreenCapture screenCapture) throws IOException {
        for (ExtentReporter r : this.reporterList) {
            r.onScreenCaptureAdded(test, screenCapture);
        }
    }

    synchronized void addScreenCapture(Log log, ScreenCapture screenCapture) throws IOException {
        for (ExtentReporter r : this.reporterList) {
            r.onScreenCaptureAdded(log, screenCapture);
        }
    }

    synchronized void addScreencast(Test test, Screencast screencast) throws IOException {
        for (ExtentReporter r : this.reporterList) {
            r.onScreencastAdded(test, screencast);
        }
    }

    protected TestAttributeTestContextProvider<Author> getAuthorContextInfo() {
        return this.authorContext;
    }

    private void updateReportStatus(Status status) {
        int reportStatusIndex;
        int statusIndex = Status.getStatusHierarchy().indexOf(status);
        this.reportStatus = statusIndex < (reportStatusIndex = Status.getStatusHierarchy().indexOf(this.reportStatus)) ? status : this.reportStatus;
    }

    private void endTest(Test test) {
        test.end();
        this.updateReportStatus(test.getStatus());
    }

    protected synchronized void flush() {
        this.reporterInitialized();
        this.collectRunInfo();
        this.notifyReporters();
    }

    private synchronized void collectRunInfo() {
        if (this.testList == null || this.testList.isEmpty()) {
            return;
        }
        this.reportEndDate = Calendar.getInstance().getTime();
        this.testList.forEach(this::endTest);
        this.refreshReportEntities();
        for (Test test : this.testList) {
            if (test.hasCategory()) {
                test.getCategoryContext().getAll().forEach(x -> this.categoryContext.setAttributeContext((Category)x, test));
            }
            if (test.hasAuthor()) {
                test.getAuthorContext().getAll().forEach(x -> this.authorContext.setAttributeContext((Author)x, test));
            }
            if (test.hasDevice()) {
                test.getDeviceContext().getAll().forEach(x -> this.deviceContext.setAttributeContext((Device)x, test));
            }
            if (test.hasException()) {
                test.getExceptionInfoList().forEach(x -> this.exceptionContextBuilder.setExceptionContext((ExceptionInfo)x, test));
            }
            if (!test.hasChildren()) continue;
            test.getNodeContext().getAll().forEach(this::copyNodeAttributeAndRunTimeInfoToAttributeContexts);
        }
        this.updateReportStartTimeForManualConfigurationSetting();
    }

    private void updateReportStartTimeForManualConfigurationSetting() {
        if (this.usesManualConfiguration) {
            Date minDate = this.testList.stream().map(t -> t.getStartTime()).min(Date::compareTo).get();
            Date maxDate = this.testList.stream().map(t -> t.getEndTime()).max(Date::compareTo).get();
            this.reportStartDate = this.reportStartDate.getTime() > minDate.getTime() ? minDate : this.reportStartDate;
            this.reportEndDate = this.reportEndDate.getTime() < maxDate.getTime() ? maxDate : this.reportEndDate;
        }
    }

    private void copyNodeAttributeAndRunTimeInfoToAttributeContexts(Test node) {
        if (node.hasCategory()) {
            node.getCategoryContext().getAll().forEach(x -> this.categoryContext.setAttributeContext((Category)x, node));
        }
        if (node.hasAuthor()) {
            node.getAuthorContext().getAll().forEach(x -> this.authorContext.setAttributeContext((Author)x, node));
        }
        if (node.hasDevice()) {
            node.getDeviceContext().getAll().forEach(x -> this.deviceContext.setAttributeContext((Device)x, node));
        }
        if (node.hasException()) {
            node.getExceptionInfoList().forEach(x -> this.exceptionContextBuilder.setExceptionContext((ExceptionInfo)x, node));
        }
        if (node.hasChildren()) {
            node.getNodeContext().getAll().forEach(this::copyNodeAttributeAndRunTimeInfoToAttributeContexts);
        }
    }

    private synchronized void notifyReporters() {
        if (!this.testList.isEmpty() && this.testList.get(0).isBehaviorDrivenType()) {
            this.strategy = AnalysisStrategy.BDD;
        }
        ReportAggregates reportAggregates = new ReportAggregatesBuilder().setAuthorContext(this.authorContext).setCategoryContext(this.categoryContext).setDeviceContext(this.deviceContext).setExceptionContext(this.exceptionContextBuilder).setReportStatusStats(this.stats).setStatusList(this.statusList).setSystemAttributeContext(this.systemAttributeContext).setTestList(this.testList).setTestRunnerLogs(this.testRunnerLogs).build();
        this.reporterList.forEach(x -> x.setAnalysisStrategy(this.strategy));
        this.reporterList.forEach(x -> x.flush(reportAggregates));
    }

    protected void end() {
        this.flush();
        this.reporterList.forEach(ExtentReporter::stop);
        this.reporterList.clear();
    }

    protected void setSystemInfo(SystemAttribute sa) {
        this.systemAttributeContext.setSystemAttribute(sa);
    }

    protected void setTestRunnerLogs(String log) {
        this.testRunnerLogs.add(log);
    }

    protected void setAnalysisStrategy(AnalysisStrategy strategy) {
        this.strategy = strategy;
        this.stats = new ReportStatusStats(strategy);
    }

    protected void setAllowManualConfig(boolean useManualConfig) {
        this.usesManualConfiguration = useManualConfig;
    }

    protected boolean getAllowManualConfig() {
        return this.usesManualConfiguration;
    }

    protected ReportStatusStats getStats() {
        return this.stats;
    }
}

