/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.configuration;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.reporter.AbstractReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BasicConfiguration {
    private AbstractReporter reporter;
    protected List<Status> levels;
    protected String reportName;
    protected String timeStampFormat;
    protected Map<String, String> usedConfigs = new HashMap<String, String>();

    protected BasicConfiguration() {
    }

    protected BasicConfiguration(AbstractReporter reporter) {
        this.reporter = reporter;
    }

    protected AbstractReporter getReporter() {
        return this.reporter;
    }

    public Map<String, String> getConfigMap() {
        return this.usedConfigs;
    }

    public void setLevel(Status ... level) {
        if (this.levels == null) {
            this.levels = new ArrayList<Status>();
        }
        Arrays.stream(level).forEach(this.levels::add);
    }

    public List<Status> getLevel() {
        return this.levels;
    }

    public String getTimeStampFormat() {
        return this.usedConfigs.get("timeStampFormat");
    }

    public void setTimeStampFormat(String timeStampFormat) {
        this.usedConfigs.put("timeStampFormat", timeStampFormat);
        this.timeStampFormat = timeStampFormat;
    }

    public void setReportName(String reportName) {
        this.usedConfigs.put("reportName", reportName);
        this.reportName = reportName;
    }

    public String getReportName() {
        return this.reportName;
    }
}

