/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.ReportStatusStats;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.SystemAttributeContext;
import com.aventstack.extentreports.TestAttributeTestContextProvider;
import com.aventstack.extentreports.externalconfig.model.Config;
import com.aventstack.extentreports.mediastorage.KlovMediaStorageHandler;
import com.aventstack.extentreports.mediastorage.model.KlovMedia;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.BasicMongoReportElement;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.SystemAttribute;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.TestAttribute;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.utils.IntUtils;
import com.aventstack.extentreports.utils.MongoUtil;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class ExtentKlovReporter
extends AbstractReporter {
    private static final String DEFAULT_PROJECT_NAME_PROP = "klov.project.name";
    private static final String DEFAULT_REPORT_NAME_PROP = "klov.report.name";
    private static final String DEFAULT_MONGODB_HOST_PROP = "mongodb.host";
    private static final String DEFAULT_MONGODB_PORT_PROP = "mongodb.port";
    private static final String DEFAULT_MONGODB_URI_PROP = "mongodb.uri";
    private static final String DEFAULT_KLOV_HOST_PROP = "klov.host";
    private static final String DEFAULT_KLOV_PORT_PROP = "klov.port";
    private static final String REPORTER_NAME = "klov";
    private static final String DB_NAME = "klov";
    private static final String DEFAULT_PROJECT_NAME = "Default";
    private String url;
    private List<Test> testList;
    private ReportStatusStats stats;
    private SystemAttributeContext systemAttributeContext;
    private TestAttributeTestContextProvider<Category> categoryContext;
    private TestAttributeTestContextProvider<Author> authorContext;
    private TestAttributeTestContextProvider<Device> deviceContext;
    private Map<String, ObjectId> categoryNameObjectIdCollection = new HashMap<String, ObjectId>();
    private Map<String, ObjectId> authorNameObjectIdCollection = new HashMap<String, ObjectId>();
    private Map<String, ObjectId> deviceNameObjectIdCollection = new HashMap<String, ObjectId>();
    private Map<String, ObjectId> exceptionNameObjectIdCollection = new HashMap<String, ObjectId>();
    private ObjectId reportId;
    private String reportName;
    private ObjectId projectId;
    private String projectName;
    private MongoClient mongoClient;
    private MongoCollection<Document> projectCollection;
    private MongoCollection<Document> reportCollection;
    private MongoCollection<Document> testCollection;
    private MongoCollection<Document> logCollection;
    private MongoCollection<Document> exceptionCollection;
    private MongoCollection<Document> mediaCollection;
    private MongoCollection<Document> categoryCollection;
    private MongoCollection<Document> authorCollection;
    private MongoCollection<Document> deviceCollection;
    private MongoCollection<Document> environmentCollection;
    private KlovMediaStorageHandler mediaStorageHandler;

    static {
        Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
        mongoLogger.setLevel(Level.SEVERE);
    }

    public ExtentKlovReporter() {
    }

    public ExtentKlovReporter(String projectName, String reportName) {
        this.projectName = projectName;
        this.reportName = reportName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public ExtentKlovReporter initMongoDbConnection(String host) {
        this.mongoClient = new MongoClient(host, 27017);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(String host, MongoClientOptions options) {
        this.mongoClient = new MongoClient(host, options);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(String host, int port) {
        this.mongoClient = new MongoClient(host, port);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(MongoClientURI uri) {
        this.mongoClient = new MongoClient(uri);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(ServerAddress addr) {
        this.mongoClient = new MongoClient(addr);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(List<ServerAddress> seeds) {
        this.mongoClient = new MongoClient(seeds);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this.mongoClient = new MongoClient(seeds, credentialsList);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this.mongoClient = new MongoClient(seeds, credentialsList, options);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(List<ServerAddress> seeds, MongoClientOptions options) {
        this.mongoClient = new MongoClient(seeds, options);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(ServerAddress addr, List<MongoCredential> credentialsList) {
        this.mongoClient = new MongoClient(addr, credentialsList);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this.mongoClient = new MongoClient(addr, credentialsList, options);
        return this;
    }

    public ExtentKlovReporter initMongoDbConnection(ServerAddress addr, MongoClientOptions options) {
        this.mongoClient = new MongoClient(addr, options);
        return this;
    }

    public ExtentKlovReporter initKlovServerConnection(String url) {
        this.url = url;
        return this;
    }

    public void loadInitializationParams(String propertiesPath) throws FileNotFoundException {
        File f = new File(propertiesPath);
        FileInputStream stream = new FileInputStream(f);
        this.loadConfig(stream);
        this.loadInitializationParams();
    }

    public void loadInitializationParams(Properties props) {
        this.loadConfig(props);
        this.loadInitializationParams();
    }

    private void loadInitializationParams() {
        List<Config> configList = this.getConfigContext().getConfigList();
        String mongoUri = this.getConfigValue(configList, DEFAULT_MONGODB_URI_PROP);
        if (mongoUri == null || mongoUri.isEmpty()) {
            int mongoPortInt;
            String mongoHost = this.getConfigValue(configList, DEFAULT_MONGODB_HOST_PROP);
            String mongoPort = this.getConfigValue(configList, DEFAULT_MONGODB_PORT_PROP);
            int n = mongoPortInt = IntUtils.tryParseInt(mongoPort) ? Integer.valueOf(mongoPort) : -1;
            if (mongoHost != null && mongoPortInt != -1) {
                this.initMongoDbConnection(mongoHost, mongoPortInt);
            } else if (mongoHost != null) {
                this.initMongoDbConnection(mongoHost);
            }
        } else {
            this.initMongoDbConnection(new MongoClientURI(mongoUri));
        }
        String projectName = System.getProperty(DEFAULT_PROJECT_NAME_PROP);
        projectName = projectName == null || projectName.isEmpty() ? this.getConfigValue(configList, DEFAULT_PROJECT_NAME_PROP) : projectName;
        this.projectName = projectName == null || projectName.isEmpty() ? this.projectName : projectName;
        String reportName = System.getProperty(DEFAULT_REPORT_NAME_PROP);
        reportName = reportName == null || reportName.isEmpty() ? this.getConfigValue(configList, DEFAULT_REPORT_NAME_PROP) : reportName;
        this.reportName = reportName == null || reportName.isEmpty() ? this.reportName : reportName;
        String klovHost = this.getConfigValue(configList, DEFAULT_KLOV_HOST_PROP);
        String klovPort = this.getConfigValue(configList, DEFAULT_KLOV_PORT_PROP);
        if (klovHost != null && klovPort != null) {
            String uri = String.valueOf(klovHost) + ":" + klovPort;
            this.initKlovServerConnection(uri);
        } else if (klovHost != null) {
            this.initKlovServerConnection(klovHost);
        }
    }

    private String getConfigValue(List<Config> configList, String key) {
        Config c = configList.stream().filter(x -> x.getKey().equalsIgnoreCase(key)).findFirst().get();
        if (c != null) {
            return String.valueOf(c.getValue());
        }
        return null;
    }

    @Override
    public void start() {
        MongoDatabase db = this.mongoClient.getDatabase("klov");
        this.initCollections(db);
        this.setupProject();
    }

    private void initCollections(MongoDatabase db) {
        this.projectCollection = db.getCollection("project");
        this.reportCollection = db.getCollection("report");
        this.testCollection = db.getCollection("test");
        this.logCollection = db.getCollection("log");
        this.exceptionCollection = db.getCollection("exception");
        this.mediaCollection = db.getCollection("media");
        this.categoryCollection = db.getCollection("category");
        this.authorCollection = db.getCollection("author");
        this.deviceCollection = db.getCollection("device");
        this.environmentCollection = db.getCollection("environment");
    }

    private void setupProject() {
        String projectName = this.projectName == null || this.projectName.isEmpty() ? DEFAULT_PROJECT_NAME : this.projectName;
        Document doc = new Document("name", (Object)projectName);
        Document project = (Document)this.projectCollection.find((Bson)doc).first();
        if (project != null) {
            this.projectId = project.getObjectId((Object)"_id");
        } else {
            doc.append("createdAt", (Object)Calendar.getInstance().getTime());
            this.projectCollection.insertOne((Object)doc);
            this.projectId = MongoUtil.getId(doc);
        }
        this.setupReport(projectName);
    }

    private void setupReport(String projectName) {
        String reportName = this.reportName == null || this.reportName.isEmpty() ? "Build " + Calendar.getInstance().getTimeInMillis() : this.reportName;
        Document doc = new Document("name", (Object)reportName).append("startTime", (Object)this.getStartTime()).append("project", (Object)this.projectId).append("projectName", (Object)projectName);
        this.reportCollection.insertOne((Object)doc);
        this.reportId = MongoUtil.getId(doc);
    }

    @Override
    public void stop() {
        this.mongoClient.close();
    }

    @Override
    public synchronized void flush(ReportAggregates reportAggregates) {
        this.setEndTime(Calendar.getInstance().getTime());
        this.testList = reportAggregates.getTestList();
        if (this.testList == null || this.testList.isEmpty()) {
            return;
        }
        this.authorContext = reportAggregates.getAuthorContext();
        this.categoryContext = reportAggregates.getCategoryContext();
        this.deviceContext = reportAggregates.getDeviceContext();
        this.stats = reportAggregates.getReportStatusStats();
        this.systemAttributeContext = reportAggregates.getSystemAttributeContext();
        Status buildStatus = reportAggregates.getStatus();
        Document doc = new Document("endTime", (Object)this.getEndTime()).append("duration", (Object)this.getRunDuration()).append("status", (Object)String.valueOf(buildStatus)).append("parentLength", (Object)this.stats.getParentCount()).append("passParentLength", (Object)this.stats.getParentCountPass()).append("failParentLength", (Object)this.stats.getParentCountFail()).append("fatalParentLength", (Object)this.stats.getParentCountFatal()).append("errorParentLength", (Object)this.stats.getParentCountError()).append("warningParentLength", (Object)this.stats.getParentCountWarning()).append("skipParentLength", (Object)this.stats.getParentCountSkip()).append("exceptionsParentLength", (Object)this.stats.getChildCountExceptions()).append("childLength", (Object)this.stats.getChildCount()).append("passChildLength", (Object)this.stats.getChildCountPass()).append("failChildLength", (Object)this.stats.getChildCountFail()).append("fatalChildLength", (Object)this.stats.getChildCountFatal()).append("errorChildLength", (Object)this.stats.getChildCountError()).append("warningChildLength", (Object)this.stats.getChildCountWarning()).append("skipChildLength", (Object)this.stats.getChildCountSkip()).append("infoChildLength", (Object)this.stats.getChildCountInfo()).append("exceptionsChildLength", (Object)this.stats.getChildCountExceptions()).append("grandChildLength", (Object)this.stats.getGrandChildCount()).append("passGrandChildLength", (Object)this.stats.getGrandChildCountPass()).append("failGrandChildLength", (Object)this.stats.getGrandChildCountFail()).append("fatalGrandChildLength", (Object)this.stats.getGrandChildCountFatal()).append("errorGrandChildLength", (Object)this.stats.getGrandChildCountError()).append("warningGrandChildLength", (Object)this.stats.getGrandChildCountWarning()).append("skipGrandChildLength", (Object)this.stats.getGrandChildCountSkip()).append("exceptionsGrandChildLength", (Object)this.stats.getGrandChildCountExceptions()).append("analysisStrategy", (Object)String.valueOf((Object)this.getAnalysisStrategy()));
        this.reportCollection.updateOne((Bson)new Document("_id", (Object)this.reportId), (Bson)new Document("$set", (Object)doc));
        this.insertUpdateSystemAttribute();
    }

    public List<ObjectId> getCollectionValues(Map<String, ObjectId> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void insertUpdateSystemAttribute() {
        List<SystemAttribute> systemAttrList = this.systemAttributeContext.getSystemAttributeList();
        for (SystemAttribute attr : systemAttrList) {
            Document doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)attr.getName());
            Document envSingle = (Document)this.environmentCollection.find((Bson)doc).first();
            if (envSingle == null) {
                doc.append("value", (Object)attr.getValue());
                this.environmentCollection.insertOne((Object)doc);
                continue;
            }
            ObjectId id = envSingle.getObjectId((Object)"_id");
            doc = new Document("_id", (Object)id).append("value", (Object)attr.getValue());
            this.environmentCollection.updateOne((Bson)new Document("_id", (Object)id), (Bson)new Document("$set", (Object)doc));
        }
    }

    @Override
    public void onTestStarted(Test test) {
        this.onTestStartedHelper(test);
    }

    @Override
    public synchronized void onNodeStarted(Test node) {
        this.onTestStartedHelper(node);
    }

    private void onTestStartedHelper(Test test) {
        Document doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("reportName", (Object)this.reportName).append("level", (Object)test.getLevel()).append("name", (Object)test.getName()).append("status", (Object)test.getStatus().toString()).append("description", (Object)test.getDescription()).append("startTime", (Object)test.getStartTime()).append("endTime", (Object)test.getEndTime()).append("bdd", (Object)test.isBehaviorDrivenType()).append("leaf", (Object)(test.getNodeContext().size() == 0 ? 1 : 0)).append("childNodesLength", (Object)test.getNodeContext().size());
        if (test.isBehaviorDrivenType()) {
            doc.append("bddType", (Object)test.getBehaviorDrivenType().getSimpleName());
        }
        if (test.getParent() != null) {
            doc.append("parent", (Object)test.getParent().getObjectId()).append("parentName", (Object)test.getParent().getName());
            this.updateTestChildrenCount(test.getParent());
            this.updateTestDesc(test.getParent());
        }
        this.testCollection.insertOne((Object)doc);
        ObjectId testId = MongoUtil.getId(doc);
        test.setObjectId(testId);
    }

    private void updateTestDesc(Test test) {
        Document doc = new Document("description", (Object)test.getDescription());
        this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
    }

    private void updateTestChildrenCount(Test test) {
        Document doc = new Document("childNodesLength", (Object)test.getNodeContext().size());
        this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
    }

    @Override
    public synchronized void onLogAdded(Test test, Log log) {
        Document doc = new Document("test", (Object)test.getObjectId()).append("project", (Object)this.projectId).append("report", (Object)this.reportId).append("testName", (Object)test.getName()).append("sequence", (Object)log.getSequence()).append("status", (Object)log.getStatus().toString()).append("timestamp", (Object)log.getTimestamp()).append("details", (Object)log.getDetails());
        if (log.hasScreenCapture() && log.getScreenCaptureContext().getFirst().isBase64().booleanValue()) {
            doc.append("details", (Object)(String.valueOf(log.getDetails()) + log.getScreenCaptureContext().getFirst().getSource()));
        }
        this.logCollection.insertOne((Object)doc);
        ObjectId logId = MongoUtil.getId(doc);
        log.setObjectId(logId);
        if (test.hasException()) {
            if (this.exceptionNameObjectIdCollection == null) {
                this.exceptionNameObjectIdCollection = new HashMap<String, ObjectId>();
            }
            ExceptionInfo ex = test.getExceptionInfoList().get(0);
            doc = new Document("report", (Object)this.reportId).append("project", (Object)this.projectId).append("name", (Object)ex.getExceptionName());
            FindIterable iterable = this.exceptionCollection.find((Bson)doc);
            Document docException = (Document)iterable.first();
            if (!this.exceptionNameObjectIdCollection.containsKey(ex.getExceptionName())) {
                if (docException != null) {
                    this.exceptionNameObjectIdCollection.put(ex.getExceptionName(), docException.getObjectId((Object)"_id"));
                } else {
                    doc = new Document("project", (Object)this.projectId).append("report", (Object)this.reportId).append("name", (Object)ex.getExceptionName()).append("stacktrace", (Object)ex.getStackTrace()).append("testCount", (Object)0);
                    this.exceptionCollection.insertOne((Object)doc);
                    ObjectId exceptionId = MongoUtil.getId(doc);
                    docException = (Document)this.exceptionCollection.find((Bson)new Document("_id", (Object)exceptionId)).first();
                    this.exceptionNameObjectIdCollection.put(ex.getExceptionName(), exceptionId);
                }
            }
            Integer testCount = (Integer)docException.get((Object)"testCount") + 1;
            doc = new Document("testCount", (Object)testCount);
            this.exceptionCollection.updateOne((Bson)new Document("_id", (Object)docException.getObjectId((Object)"_id")), (Bson)new Document("$set", (Object)doc));
            doc = new Document("exception", (Object)this.exceptionNameObjectIdCollection.get(ex.getExceptionName()));
            this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
            this.updateTestDesc(test);
        }
        this.endTestRecursive(test);
    }

    private void endTestRecursive(Test test) {
        Document doc = new Document("status", (Object)test.getStatus().toString()).append("endTime", (Object)test.getEndTime()).append("duration", (Object)test.getRunDurationMillis()).append("leaf", (Object)(test.getNodeContext().size() == 0 ? 1 : 0)).append("childNodesLength", (Object)test.getNodeContext().size()).append("categorized", (Object)test.hasCategory()).append("description", (Object)test.getDescription());
        this.testCollection.updateOne((Bson)new Document("_id", (Object)test.getObjectId()), (Bson)new Document("$set", (Object)doc));
        if (test.getLevel() > 0) {
            this.endTestRecursive(test.getParent());
        }
    }

    public <T extends TestAttribute> void assignAttribute(Test test, TestAttribute attribute, Map<String, ObjectId> nameObjectIdCollection, MongoCollection<Document> mongoCollection, TestAttributeTestContextProvider<T> attributeContext) {
    }

    @Override
    public void onCategoryAssigned(Test test, Category category) {
        this.assignAttribute(test, category, this.categoryNameObjectIdCollection, this.categoryCollection, this.categoryContext);
    }

    @Override
    public void onAuthorAssigned(Test test, Author author) {
        this.assignAttribute(test, author, this.authorNameObjectIdCollection, this.authorCollection, this.authorContext);
    }

    @Override
    public void onScreenCaptureAdded(Test test, ScreenCapture screenCapture) throws IOException {
        this.saveScreenCapture(test, screenCapture);
    }

    @Override
    public void onScreenCaptureAdded(Log log, ScreenCapture screenCapture) throws IOException {
        screenCapture.setLogObjectId(log.getObjectId());
        this.saveScreenCapture(log, screenCapture);
    }

    private void saveScreenCapture(BasicMongoReportElement el, ScreenCapture screenCapture) throws IOException {
        if (this.mediaStorageHandler == null) {
            KlovMedia klovMedia = new KlovMedia(this.projectId, this.reportId, this.mediaCollection);
            this.mediaStorageHandler = new KlovMediaStorageHandler(this.url, klovMedia);
        }
        this.mediaStorageHandler.saveScreenCapture(el, screenCapture);
    }

    @Override
    public void onScreencastAdded(Test test, Screencast screencast) throws IOException {
    }

    public ObjectId getProjectId() {
        return this.projectId;
    }

    public ObjectId getReportId() {
        return this.reportId;
    }

    @Override
    public void onTestRemoved(Test test) {
    }

    @Override
    public void onDeviceAssigned(Test test, Device device) {
        this.assignAttribute(test, device, this.deviceNameObjectIdCollection, this.deviceCollection, this.deviceContext);
    }

    @Override
    public String getReporterName() {
        return "klov";
    }
}

